/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.tabletop.dice.interpreter;

import com.bernardomg.tabletop.dice.Dice;
import com.bernardomg.tabletop.dice.history.RollHistory;
import com.bernardomg.tabletop.dice.history.RollResult;
import com.bernardomg.tabletop.dice.interpreter.ConfigurableInterpreter;
import com.bernardomg.tabletop.dice.interpreter.DiceInterpreter;
import com.bernardomg.tabletop.dice.interpreter.PostorderTraverser;
import com.bernardomg.tabletop.dice.notation.DiceNotationExpression;
import com.bernardomg.tabletop.dice.random.DiceToRollResult;
import com.bernardomg.tabletop.dice.random.NumberGenerator;
import com.bernardomg.tabletop.dice.visitor.DiceRollAccumulator;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public final class DiceRoller
implements DiceInterpreter<RollHistory> {
    private final DiceInterpreter<RollHistory> wrapped;

    public DiceRoller() {
        this(new DiceToRollResult());
    }

    public DiceRoller(Function<Dice, RollResult> roller) {
        this.wrapped = new ConfigurableInterpreter<RollHistory>(new PostorderTraverser(), new DiceRollAccumulator(roller));
    }

    public DiceRoller(Function<Dice, RollResult> roller, UnaryOperator<RollResult> transformer) {
        Function<Dice, RollResult> finalRoller = roller.andThen(transformer);
        this.wrapped = new ConfigurableInterpreter<RollHistory>(new PostorderTraverser(), new DiceRollAccumulator(finalRoller));
    }

    public DiceRoller(NumberGenerator generator) {
        this(new DiceToRollResult(generator));
    }

    public DiceRoller(NumberGenerator generator, UnaryOperator<RollResult> transformer) {
        Function<Dice, RollResult> finalRoller = new DiceToRollResult(generator).andThen(transformer);
        this.wrapped = new ConfigurableInterpreter<RollHistory>(new PostorderTraverser(), new DiceRollAccumulator(finalRoller));
    }

    @Override
    public final RollHistory transform(DiceNotationExpression expression) {
        return this.wrapped.transform(expression);
    }
}

