/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.tabletop.dice.notation.operand;

import com.bernardomg.tabletop.dice.Dice;
import com.bernardomg.tabletop.dice.notation.operand.DiceOperand;
import lombok.NonNull;

public final class DefaultDiceOperand
implements DiceOperand {
    @NonNull
    private final Dice dice;

    @Override
    public final String getExpression() {
        return String.format("%dd%d", this.getDice().getQuantity(), this.getDice().getSides());
    }

    public DefaultDiceOperand(@NonNull Dice dice) {
        if (dice == null) {
            throw new NullPointerException("dice is marked non-null but is null");
        }
        this.dice = dice;
    }

    @Override
    @NonNull
    public Dice getDice() {
        return this.dice;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultDiceOperand)) {
            return false;
        }
        DefaultDiceOperand other = (DefaultDiceOperand)o;
        Dice this$dice = this.getDice();
        Dice other$dice = other.getDice();
        return !(this$dice == null ? other$dice != null : !this$dice.equals(other$dice));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Dice $dice = this.getDice();
        result = result * 59 + ($dice == null ? 43 : $dice.hashCode());
        return result;
    }

    public String toString() {
        return "DefaultDiceOperand(dice=" + this.getDice() + ")";
    }
}

