/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.tabletop.dice.random;

import com.bernardomg.tabletop.dice.random.AbstractNumberGenerator;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RandomNumberGenerator
extends AbstractNumberGenerator {
    private static final Logger log = LoggerFactory.getLogger(RandomNumberGenerator.class);
    private static final Integer LOWER_LIMIT = 1;
    private final Random random = new Random();

    @Override
    public final Integer generate(Integer max) {
        Integer result;
        if (max < LOWER_LIMIT) {
            log.warn("Received {} as maximum value, but this is lower than {}", (Object)max, (Object)LOWER_LIMIT);
            result = 0;
        } else {
            result = this.random.nextInt(Math.abs(LOWER_LIMIT - max) + 1) + LOWER_LIMIT;
            log.debug("Using interval [{},{}] generated {}", new Object[]{LOWER_LIMIT, max, result});
        }
        return result;
    }
}

