/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.tabletop.dice.parser;

import com.bernardomg.tabletop.dice.generated.DiceNotationLexer;
import com.bernardomg.tabletop.dice.generated.DiceNotationParser;
import com.bernardomg.tabletop.dice.interpreter.DiceInterpreter;
import com.bernardomg.tabletop.dice.notation.DiceNotationExpression;
import com.bernardomg.tabletop.dice.parser.DiceParser;
import com.bernardomg.tabletop.dice.parser.listener.DefaultDiceExpressionBuilder;
import com.bernardomg.tabletop.dice.parser.listener.DefaultErrorListener;
import com.bernardomg.tabletop.dice.parser.listener.DiceExpressionBuilder;
import java.util.Objects;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public final class DefaultDiceParser
implements DiceParser {
    private final ANTLRErrorListener errorListener;
    private final DiceExpressionBuilder expressionBuilder;

    public DefaultDiceParser() {
        this.errorListener = new DefaultErrorListener();
        this.expressionBuilder = new DefaultDiceExpressionBuilder();
    }

    public DefaultDiceParser(ANTLRErrorListener listener) {
        this.errorListener = Objects.requireNonNull(listener, "Received a null pointer as listener");
        this.expressionBuilder = new DefaultDiceExpressionBuilder();
    }

    public DefaultDiceParser(DiceExpressionBuilder builder) {
        this.errorListener = new DefaultErrorListener();
        this.expressionBuilder = Objects.requireNonNull(builder, "Received a null pointer as expression builder");
    }

    public DefaultDiceParser(DiceExpressionBuilder builder, ANTLRErrorListener listener) {
        this.errorListener = Objects.requireNonNull(listener, "Received a null pointer as listener");
        this.expressionBuilder = Objects.requireNonNull(builder, "Received a null pointer as expression builder");
    }

    @Override
    public final DiceNotationExpression parse(String expression) {
        Objects.requireNonNull(expression, "Received a null pointer as string");
        DiceNotationParser parser = this.buildDiceNotationParser(expression);
        parser.notation();
        return this.expressionBuilder.getDiceExpressionRoot();
    }

    @Override
    public final <V> V parse(String expression, DiceInterpreter<V> interpreter) {
        DiceNotationExpression parsed = this.parse(expression);
        return interpreter.transform(parsed);
    }

    private final DiceNotationParser buildDiceNotationParser(String expression) {
        CodePointCharStream stream = CharStreams.fromString((String)expression);
        DiceNotationLexer lexer = new DiceNotationLexer((CharStream)stream);
        lexer.addErrorListener(this.errorListener);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        DiceNotationParser parser = new DiceNotationParser((TokenStream)tokens);
        parser.addErrorListener(this.errorListener);
        parser.addParseListener(this.expressionBuilder);
        return parser;
    }
}

