/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.tabletop.dice.random;

import com.bernardomg.tabletop.dice.Dice;
import com.bernardomg.tabletop.dice.random.NumberGenerator;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNumberGenerator
implements NumberGenerator {
    private static final Logger log = LoggerFactory.getLogger(AbstractNumberGenerator.class);

    protected AbstractNumberGenerator() {
    }

    @Override
    public final Iterable<Integer> generate(Dice dice) {
        Supplier<Integer> rollSupplier;
        Integer quantity;
        Objects.requireNonNull(dice, "Received a null pointer as dice");
        if (dice.getQuantity() < 0) {
            log.trace("Negative dice set");
            quantity = 0 - dice.getQuantity();
            rollSupplier = () -> 0 - this.generate(dice.getSides());
        } else {
            log.trace("Positive dice set");
            quantity = dice.getQuantity();
            rollSupplier = () -> this.generate(dice.getSides());
        }
        ArrayList<Integer> rolls = new ArrayList<Integer>();
        Integer i = 0;
        while (i < quantity) {
            rolls.add(rollSupplier.get());
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return rolls;
    }
}

