/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.tabletop.dice.random;

import com.bernardomg.tabletop.dice.Dice;
import com.bernardomg.tabletop.dice.history.DefaultRollResult;
import com.bernardomg.tabletop.dice.history.RollResult;
import com.bernardomg.tabletop.dice.random.NumberGenerator;
import com.bernardomg.tabletop.dice.random.RandomNumberGenerator;
import java.util.Objects;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiceToRollResult
implements Function<Dice, RollResult> {
    private static final Logger log = LoggerFactory.getLogger(DiceToRollResult.class);
    private final NumberGenerator numberGenerator;

    public DiceToRollResult() {
        this.numberGenerator = new RandomNumberGenerator();
    }

    public DiceToRollResult(NumberGenerator generator) {
        this.numberGenerator = Objects.requireNonNull(generator, "Received a null pointer as generator");
    }

    @Override
    public final RollResult apply(Dice dice) {
        Iterable<Integer> rolls = this.numberGenerator.generate(dice);
        Integer total = 0;
        for (Integer roll : rolls) {
            total = total + roll;
        }
        log.debug("Rolled {}", (Object)dice);
        log.debug("Generated rolls: {}", rolls);
        log.debug("Total roll: {}", (Object)total);
        return new DefaultRollResult(dice, rolls, total);
    }
}

