/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.velocity.tool;

import java.util.Objects;
import org.apache.velocity.tools.config.DefaultKey;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.Tag;
import org.jsoup.select.Elements;

@DefaultKey(value="html5UpdateTool")
public class Html5UpdateTool {
    public final Element removePointsFromAttr(Element root, String selector, String attr) {
        Objects.requireNonNull(root, "Received a null pointer as root element");
        Objects.requireNonNull(selector, "Received a null pointer as selector");
        Objects.requireNonNull(attr, "Received a null pointer as attribute");
        Elements elements = root.select(selector);
        for (Element selected : elements) {
            this.removePointsFromAttr(selected, attr);
        }
        return root;
    }

    public final Element updateTableHeads(Element root) {
        Objects.requireNonNull(root, "Received a null pointer as root element");
        Elements tableHeadRows = root.select("table > tbody > tr:has(th)");
        for (Element row : tableHeadRows) {
            Element table = row.parent().parent();
            row.remove();
            Element thead = new Element(Tag.valueOf((String)"thead"), "");
            thead.appendChild((Node)row);
            table.prependChild((Node)thead);
        }
        return root;
    }

    private final void removePointsFromAttr(Element element, String attr) {
        String value = element.attr(attr).replace(".", "");
        element.attr(attr, value);
    }
}

