/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.velocity.tool;

import java.util.Objects;
import org.apache.velocity.tools.config.DefaultKey;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

@DefaultKey(value="htmlTool")
public final class HtmlTool {
    public final Element addClass(Element root, String selector, String className) {
        Objects.requireNonNull(root, "Received a null pointer as root element");
        Objects.requireNonNull(selector, "Received a null pointer as selector");
        Objects.requireNonNull(className, "Received a null pointer as class");
        Elements elements = root.select(selector);
        for (Element element : elements) {
            element.addClass(className);
        }
        return root;
    }

    public final Element parse(String html) {
        Objects.requireNonNull(html, "Received a null pointer as body");
        return Jsoup.parse((String)html).body();
    }

    public final Element removeAttribute(Element root, String selector, String attribute) {
        Objects.requireNonNull(root, "Received a null pointer as root element");
        Objects.requireNonNull(selector, "Received a null pointer as selector");
        Objects.requireNonNull(attribute, "Received a null pointer as attribute");
        Elements elements = root.select(selector);
        for (Element element : elements) {
            element.removeAttr(attribute);
        }
        return root;
    }

    public final Element removeClass(Element root, String selector, String className) {
        Objects.requireNonNull(root, "Received a null pointer as root element");
        Objects.requireNonNull(selector, "Received a null pointer as selector");
        Objects.requireNonNull(className, "Received a null pointer as className");
        Elements elements = root.select(selector);
        for (Element element : elements) {
            element.removeClass(className);
            if (!element.classNames().isEmpty()) continue;
            element.removeAttr("class");
        }
        return root;
    }

    public final Element retag(Element root, String selector, String tag) {
        Objects.requireNonNull(root, "Received a null pointer as root element");
        Objects.requireNonNull(selector, "Received a null pointer as selector");
        Objects.requireNonNull(tag, "Received a null pointer as tag");
        Elements elements = root.select(selector);
        for (Element element : elements) {
            element.tagName(tag);
        }
        return root;
    }

    public final Element swapTagWithParent(Element root, String selector) {
        Objects.requireNonNull(root, "Received a null pointer as root element");
        Objects.requireNonNull(selector, "Received a null pointer as selector");
        Elements elements = root.select(selector);
        for (Element element : elements) {
            Element parent = element.parent();
            String text = element.text();
            element.text("");
            parent.replaceWith((Node)element);
            element.appendChild((Node)parent);
            parent.text(text);
        }
        return root;
    }

    public final Element unwrap(Element root, String selector) {
        Objects.requireNonNull(root, "Received a null pointer as root element");
        Objects.requireNonNull(selector, "Received a null pointer as selector");
        Elements elements = root.select(selector);
        for (Element element : elements) {
            element.unwrap();
        }
        return root;
    }

    public final Element wrap(Element root, String selector, String wrapper) {
        Objects.requireNonNull(root, "Received a null pointer as root element");
        Objects.requireNonNull(selector, "Received a null pointer as selector");
        Objects.requireNonNull(wrapper, "Received a null pointer as HTML wrap");
        Elements elements = root.select(selector);
        for (Element element : elements) {
            element.wrap(wrapper);
        }
        return root;
    }
}

