/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.velocity.tool;

import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.velocity.tools.ToolContext;
import org.apache.velocity.tools.config.DefaultKey;
import org.apache.velocity.tools.generic.SafeConfig;
import org.apache.velocity.tools.generic.ValueParser;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@DefaultKey(value="config")
public final class ConfigTool
extends SafeConfig {
    private String fileId;
    private final Pattern multipleHyphen = Pattern.compile("-+");
    private final Pattern nonLatin = Pattern.compile("[^\\w-]");
    private Xpp3Dom skinConfig = new Xpp3Dom("");
    private final Pattern whitespace = Pattern.compile("[\\s]");

    public final Xpp3Dom get(String property) {
        Objects.requireNonNull(property, "Received a null pointer as property");
        return this.getSkinConfig().getChild(property);
    }

    public final String getFileId() {
        return this.fileId;
    }

    private final Pattern getMultipleHyphenPattern() {
        return this.multipleHyphen;
    }

    private final Pattern getNonLatinPattern() {
        return this.nonLatin;
    }

    private final Xpp3Dom getSkinConfig() {
        return this.skinConfig;
    }

    private final Pattern getWhitespacePattern() {
        return this.whitespace;
    }

    private final void loadFileId(ToolContext context) {
        if (context.containsKey("currentFileName")) {
            Object currentFileObj = context.get("currentFileName");
            if (currentFileObj == null) {
                this.setFileId("");
            } else {
                String currentFile = String.valueOf(currentFileObj);
                Integer lastDot = currentFile.lastIndexOf(46);
                if (lastDot >= 0) {
                    currentFile = currentFile.substring(0, lastDot);
                }
                this.setFileId(this.slug(currentFile));
            }
        } else {
            this.setFileId("");
        }
    }

    private final void processDecoration(DecorationModel model) {
        Object customObj = model.getCustom();
        if (customObj instanceof Xpp3Dom) {
            Xpp3Dom customNode = (Xpp3Dom)customObj;
            Xpp3Dom skinNode = customNode.getChild("skinConfig");
            if (skinNode == null) {
                this.setSkinConfig(new Xpp3Dom(""));
            } else {
                this.setSkinConfig(skinNode);
            }
        }
    }

    private final void setFileId(String id) {
        this.fileId = id;
    }

    private final void setSkinConfig(Xpp3Dom config) {
        this.skinConfig = config;
    }

    private final String slug(String text) {
        Objects.requireNonNull(text, "Received a null pointer as the text");
        String separator = "-";
        String corrected = text.replace('/', '-').replace('\\', '-').replace('.', '-').replace('_', '-');
        corrected = this.getMultipleHyphenPattern().matcher(corrected).replaceAll(separator);
        corrected = this.getWhitespacePattern().matcher(corrected).replaceAll(separator);
        corrected = this.getNonLatinPattern().matcher(corrected).replaceAll("");
        return corrected.toLowerCase();
    }

    protected final void configure(ValueParser values) {
        Objects.requireNonNull(values, "Received a null pointer as values");
        Object velocityContext = values.get("velocityContext");
        if (velocityContext instanceof ToolContext) {
            ToolContext ctxt = (ToolContext)velocityContext;
            this.loadFileId(ctxt);
            Object decorationObj = ctxt.get("decoration");
            if (decorationObj instanceof DecorationModel) {
                this.processDecoration((DecorationModel)decorationObj);
            }
        }
    }
}

