/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.velocity.tool;

import com.bernardomg.velocity.tool.ConfigToolRegex;
import java.util.Locale;
import java.util.Objects;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.velocity.tools.ToolContext;
import org.apache.velocity.tools.config.DefaultKey;
import org.apache.velocity.tools.generic.SafeConfig;
import org.apache.velocity.tools.generic.ValueParser;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@DefaultKey(value="config")
public final class ConfigTool
extends SafeConfig {
    private String fileId;
    private Xpp3Dom skinConfig = new Xpp3Dom("");

    public final Xpp3Dom get(String property) {
        Objects.requireNonNull(property, "Received a null pointer as property");
        return this.skinConfig.getChild(property);
    }

    public final String getFileId() {
        return this.fileId;
    }

    public final Xpp3Dom getSkinConfig() {
        return this.skinConfig;
    }

    public final void setFileId(String id) {
        this.fileId = id;
    }

    public final void setSkinConfig(Xpp3Dom config) {
        this.skinConfig = config;
    }

    private final void loadFileId(ToolContext context) {
        String id;
        if (context.containsKey("currentFileName")) {
            Object currentFileObj = context.get("currentFileName");
            if (currentFileObj == null) {
                id = "";
            } else {
                String currentFile = String.valueOf(currentFileObj);
                Integer lastDot = currentFile.lastIndexOf(46);
                if (lastDot >= 0) {
                    currentFile = currentFile.substring(0, lastDot);
                }
                id = this.slug(currentFile);
            }
        } else {
            id = "";
        }
        this.fileId = id;
    }

    private final void processDecoration(DecorationModel model) {
        Object customObj = model.getCustom();
        if (customObj instanceof Xpp3Dom) {
            Xpp3Dom customNode = (Xpp3Dom)customObj;
            Xpp3Dom skinNode = customNode.getChild("skinConfig");
            this.skinConfig = skinNode == null ? new Xpp3Dom("") : skinNode;
        }
    }

    private final String slug(String text) {
        Objects.requireNonNull(text, "Received a null pointer as the text");
        String separator = "-";
        String corrected = text.replace('/', '-').replace('\\', '-').replace('.', '-').replace('_', '-');
        corrected = ConfigToolRegex.MULTIPLE_HYPHEN.matcher(corrected).replaceAll(separator);
        corrected = ConfigToolRegex.WHITESPACE.matcher(corrected).replaceAll(separator);
        corrected = ConfigToolRegex.NON_LATIN.matcher(corrected).replaceAll("");
        return corrected.toLowerCase(Locale.getDefault());
    }

    protected final void configure(ValueParser values) {
        Objects.requireNonNull(values, "Received a null pointer as values");
        Object velocityContext = values.get("velocityContext");
        if (velocityContext instanceof ToolContext) {
            ToolContext ctxt = (ToolContext)velocityContext;
            this.loadFileId(ctxt);
            Object decorationObj = ctxt.get("decoration");
            if (decorationObj instanceof DecorationModel) {
                this.processDecoration((DecorationModel)decorationObj);
            }
        }
    }
}

