/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader;

import com.berryworks.edireader.AnsiFAGenerator;
import com.berryworks.edireader.StandardReader;
import com.berryworks.edireader.util.BranchingWriter;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ansi999Generator
extends AnsiFAGenerator {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getSimpleName());
    private static final String CONTROL_NUMBER_999 = "0001";

    public Ansi999Generator(StandardReader ansiReader, BranchingWriter ackStream) {
        super(ansiReader, ackStream);
    }

    @Override
    public void generateAcknowledgmentHeader(String firstSegment, String groupSender, String groupReceiver, int groupDateLength, String groupVersion, String groupFunctionCode, String groupControlNumber) throws IOException {
        if (this.ackStream == null) {
            return;
        }
        if ("FA".equals(groupFunctionCode)) {
            this.skipFA = true;
            return;
        }
        this.skipFA = false;
        logger.debug("generating FA envelope");
        this.generateAcknowledgementPreamble(firstSegment, groupSender, groupReceiver, groupDateLength, groupVersion);
        logger.debug("generating first part of 999");
        ++this.thisDocumentCount;
        this.ackStream.write("ST" + this.delimiter + "999" + this.delimiter + CONTROL_NUMBER_999 + this.delimiter + groupVersion);
        this.ackStream.write(this.terminatorWithSuffix);
        this.ackStream.write("AK1" + this.delimiter + groupFunctionCode + this.delimiter + groupControlNumber);
        this.ackStream.write(this.terminatorWithSuffix);
        this.headerGenerated = true;
    }

    @Override
    protected void generateTransactionAcknowledgmentUsing(String transactionCode, String controlNumber) {
        logger.debug("generating AK2/IK5");
        this.ackStream.writeTrunk("AK2" + this.delimiter + transactionCode + this.delimiter + controlNumber);
        this.ackStream.writeTrunk(this.terminatorWithSuffix);
        this.ackStream.writeTrunk("IK5" + this.delimiter + "A");
        this.ackStream.writeTrunk(this.terminatorWithSuffix);
    }
}

