/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader;

import com.berryworks.edireader.ReplyGenerator;
import com.berryworks.edireader.StandardReader;
import com.berryworks.edireader.SyntaxDescriptor;
import com.berryworks.edireader.util.BranchingWriter;
import com.berryworks.edireader.util.DateTimeGenerator;
import com.berryworks.edireader.util.FixedLength;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnsiFAGenerator
extends ReplyGenerator {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getSimpleName());
    public static final String REGEX_CHARS_NEEDING_ESCAPE = "\\.[{(*+?^$|";
    public static final String REGEX_PREFIX = "\\";
    protected final BranchingWriter ackStream;
    protected boolean preambleGenerated;
    protected boolean skipFA;
    protected String thisInterchangeControlNumber;
    protected String thisGroupControlNumber;
    protected int thisDocumentCount;
    protected String referencedISA;
    protected boolean headerGenerated;
    protected boolean groupTrailerGenerated;
    protected char delimiter;
    protected String terminatorWithSuffix;
    private static final String CONTROL_NUMBER_997 = "0001";

    public AnsiFAGenerator(StandardReader ansiReader, BranchingWriter ackStream) {
        this.standardReader = ansiReader;
        this.ackStream = ackStream;
    }

    @Override
    public void generateAcknowledgmentHeader(String firstSegment, String groupSender, String groupReceiver, int groupDateLength, String groupVersion, String groupFunctionCode, String groupControlNumber) throws IOException {
        if (this.ackStream == null) {
            return;
        }
        if ("FA".equals(groupFunctionCode)) {
            this.skipFA = true;
            return;
        }
        this.skipFA = false;
        logger.debug("generating FA envelope");
        this.generateAcknowledgementPreamble(firstSegment, groupSender, groupReceiver, groupDateLength, groupVersion);
        logger.debug("generating first part of 997");
        ++this.thisDocumentCount;
        this.ackStream.write("ST" + this.delimiter + "997" + this.delimiter + CONTROL_NUMBER_997);
        this.ackStream.write(this.terminatorWithSuffix);
        this.ackStream.write("AK1" + this.delimiter + groupFunctionCode + this.delimiter + groupControlNumber);
        this.ackStream.write(this.terminatorWithSuffix);
        this.headerGenerated = true;
    }

    @Override
    public void generateTransactionAcknowledgment(String transactionCode, String controlNumber) throws IOException {
        if (this.ackStream == null || this.skipFA || this.standardReader.isGroupAcknowledgment()) {
            return;
        }
        this.generateTransactionAcknowledgmentUsing(transactionCode, controlNumber);
    }

    protected void generateTransactionAcknowledgmentUsing(String transactionCode, String controlNumber) {
        logger.debug("generating AK2/AK5");
        this.ackStream.writeTrunk("AK2" + this.delimiter + transactionCode + this.delimiter + controlNumber);
        this.ackStream.writeTrunk(this.terminatorWithSuffix);
        this.ackStream.writeTrunk("AK5" + this.delimiter + "A");
        this.ackStream.writeTrunk(this.terminatorWithSuffix);
    }

    @Override
    public void generateGroupAcknowledgmentTrailer(int docCount) throws IOException {
        if (this.ackStream == null || this.skipFA) {
            return;
        }
        logger.debug("generating AK9, SE");
        this.ackStream.writeTrunk("AK9" + this.delimiter + "A" + this.delimiter + docCount + this.delimiter + docCount + this.delimiter + docCount);
        this.ackStream.writeBranch("AK9" + this.delimiter + "R" + this.delimiter + docCount + this.delimiter + docCount + this.delimiter + "0");
        this.ackStream.write(this.terminatorWithSuffix);
        int segmentCount = 4 + (this.standardReader.isGroupAcknowledgment() ? 0 : 2 * docCount);
        this.ackStream.writeTrunk("SE" + this.delimiter + segmentCount + this.delimiter + CONTROL_NUMBER_997);
        this.ackStream.writeBranch("SE" + this.delimiter + "4" + this.delimiter + CONTROL_NUMBER_997);
        this.ackStream.write(this.terminatorWithSuffix);
        this.groupTrailerGenerated = true;
    }

    @Override
    public void generateNegativeACK() throws IOException {
        if (this.ackStream == null || this.skipFA || !this.headerGenerated) {
            return;
        }
        logger.debug("recasting 997 as negative");
        if (!this.groupTrailerGenerated) {
            this.generateGroupAcknowledgmentTrailer(0);
        }
        this.generateAcknowledgementWrapup(false);
    }

    @Override
    public void generateAcknowledgementWrapup() throws IOException {
        this.generateAcknowledgementWrapup(true);
    }

    public void generateAcknowledgementWrapup(boolean positiveFA) throws IOException {
        if (this.ackStream == null || this.skipFA) {
            return;
        }
        logger.debug("generating GE, IEA");
        this.ackStream.write("GE" + this.delimiter + this.thisDocumentCount + this.delimiter + this.thisGroupControlNumber);
        this.ackStream.write(this.terminatorWithSuffix);
        this.ackStream.write("IEA" + this.delimiter + "1" + this.delimiter + this.thisInterchangeControlNumber);
        this.ackStream.write(this.terminatorWithSuffix);
        if (positiveFA) {
            this.ackStream.close();
        } else {
            this.ackStream.closeUsingBranch();
        }
    }

    protected void generateAcknowledgementPreamble(String firstSegment, String groupSender, String groupReceiver, int groupDateLength, String groupVersion) throws IOException {
        if (this.ackStream == null || this.preambleGenerated) {
            return;
        }
        this.referencedISA = firstSegment;
        this.establishSyntaxCharacters();
        String[] isaFields = this.splitOnDelimiter();
        if (isaFields.length < 17) {
            throw new RuntimeException("*** Internal Error: Unable to interpret input ISA when forming ISA for acknowledgement. " + this.referencedISA);
        }
        this.thisInterchangeControlNumber = FixedLength.valueOf(isaFields[13], 9);
        String faHeader = isaFields[0] + this.delimiter + FixedLength.valueOf(isaFields[1], 2) + this.delimiter + FixedLength.valueOf(isaFields[2], 10) + this.delimiter + FixedLength.valueOf(isaFields[3], 2) + this.delimiter + FixedLength.valueOf(isaFields[4], 10) + this.delimiter + FixedLength.valueOf(isaFields[7], 2) + this.delimiter + FixedLength.valueOf(isaFields[8], 15) + this.delimiter + FixedLength.valueOf(isaFields[5], 2) + this.delimiter + FixedLength.valueOf(isaFields[6], 15) + this.delimiter + DateTimeGenerator.generate(this.delimiter) + this.delimiter + FixedLength.valueOf(isaFields[11], 1) + this.delimiter + FixedLength.valueOf(isaFields[12], 5) + this.delimiter + this.thisInterchangeControlNumber + this.delimiter + "0" + this.delimiter + FixedLength.valueOf(isaFields[15], 1) + this.delimiter + FixedLength.valueOf(isaFields[16], 1);
        this.thisInterchangeControlNumber = this.thisInterchangeControlNumber.trim();
        char senderDelimiter = this.standardReader.getDelimiter();
        if (senderDelimiter != this.delimiter) {
            faHeader = faHeader.replace(senderDelimiter, this.delimiter);
        }
        this.ackStream.write(faHeader);
        this.ackStream.write(this.terminatorWithSuffix);
        if (this.standardReader.isInterchangeAcknowledgment()) {
            this.ackStream.write("TA1" + this.delimiter + this.thisInterchangeControlNumber + this.delimiter + FixedLength.valueOf(isaFields[9], 6) + this.delimiter + FixedLength.valueOf(isaFields[10], 4) + this.delimiter);
            this.ackStream.writeTrunk("A" + this.delimiter + "000");
            this.ackStream.writeBranch("R" + this.delimiter + "022");
            this.ackStream.write(this.terminatorWithSuffix);
        }
        this.thisGroupControlNumber = this.thisInterchangeControlNumber;
        this.ackStream.write("GS" + this.delimiter + "FA" + this.delimiter + groupReceiver + this.delimiter + groupSender + this.delimiter + this.controlDateAndTime(groupDateLength, this.delimiter) + this.delimiter + this.thisGroupControlNumber + this.delimiter + "X" + this.delimiter + groupVersion);
        this.ackStream.write(this.terminatorWithSuffix);
        this.preambleGenerated = true;
    }

    private String[] splitOnDelimiter() {
        String delimiterAsString = String.valueOf(this.referencedISA.charAt(3));
        String delimiterPattern = REGEX_CHARS_NEEDING_ESCAPE.contains(delimiterAsString) ? REGEX_PREFIX + this.delimiter : delimiterAsString;
        return this.referencedISA.split(delimiterPattern);
    }

    private void establishSyntaxCharacters() {
        SyntaxDescriptor sd = this.standardReader.getAcknowledgmentSyntaxDescriptor();
        char terminator = '\u0000';
        String terminatorSuffix = null;
        if (sd == null) {
            this.delimiter = '\u0000';
        } else {
            this.delimiter = sd.getDelimiter();
            terminator = sd.getTerminator();
            terminatorSuffix = sd.getTerminatorSuffix();
        }
        if (this.delimiter == '\u0000') {
            this.delimiter = this.standardReader.getDelimiter();
        }
        if (terminator == '\u0000') {
            terminator = this.standardReader.getTerminator();
        }
        if (terminatorSuffix == null) {
            terminatorSuffix = this.standardReader.getTerminatorSuffix();
        }
        this.terminatorWithSuffix = terminator + terminatorSuffix;
    }

    @Override
    public void generateAcknowledgmentHeader(String syntaxIdentifier, String syntaxVersionNumber, String fromId, String fromQual, String toId, String toQual, String interchangeControlNumber) {
    }
}

