/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader;

import com.berryworks.edireader.Ansi999Generator;
import com.berryworks.edireader.AnsiFAGenerator;
import com.berryworks.edireader.EDIAttributes;
import com.berryworks.edireader.EDIStandard;
import com.berryworks.edireader.EDISyntaxException;
import com.berryworks.edireader.PluginController;
import com.berryworks.edireader.ReplyGenerator;
import com.berryworks.edireader.StandardReader;
import com.berryworks.edireader.error.ISA16SubElementDelimiterException;
import com.berryworks.edireader.error.ISAFixedLengthException;
import com.berryworks.edireader.error.MissingMandatoryElementException;
import com.berryworks.edireader.tokenizer.Token;
import com.berryworks.edireader.util.ContentHandlerBase64Encoder;
import com.berryworks.edireader.util.FixedLength;
import com.berryworks.edireader.util.sax.QueuedContentHandler;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class AnsiReader
extends StandardReader {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getSimpleName());
    protected String groupFunctionCode;
    protected String groupSender;
    protected String groupReceiver;
    protected String groupDate;
    protected String groupVersion;

    @Override
    protected Token recognizeBeginning() throws IOException, EDISyntaxException {
        Token t = this.getTokenizer().nextToken();
        if (t.getType() != Token.TokenType.SEGMENT_START || !t.valueEquals("ISA")) {
            logger.warn("ANSI X.12 interchange must begin with ISA");
            throw new EDISyntaxException("ANSI X.12 interchange must begin with ISA");
        }
        return t;
    }

    @Override
    protected Token parseInterchange(Token token) throws SAXException, IOException {
        EDISyntaxException se;
        ISA16SubElementDelimiterException syntaxException;
        this.setGroupCount(0);
        this.getInterchangeAttributes().clear();
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getStandard(), EDIStandard.ANSI.getDisplayName());
        String authQual = this.checkFixedLength("ISA01", this.nextField(), 2);
        String authInfo = this.checkFixedLength("ISA02", this.nextField(), 10);
        String securityQual = this.checkFixedLength("ISA03", this.nextField(), 2);
        String securityInfo = this.checkFixedLength("ISA04", this.nextField(), 10);
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getAuthorizationQual(), authQual);
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getAuthorization(), authInfo);
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getSecurityQual(), securityQual);
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getSecurity(), securityInfo);
        String fromQual = this.checkFixedLength("ISA05", this.nextField(), 2);
        this.process("ISA05", fromQual);
        String fromId = this.checkFixedLength("ISA06", this.nextField(), 15);
        this.process("ISA06", fromId);
        String toQual = this.checkFixedLength("ISA07", this.nextField(), 2);
        this.process("ISA07", toQual);
        String toId = this.checkFixedLength("ISA08", this.nextField(), 15);
        this.process("ISA08", fromId);
        String controlDate = this.checkFixedLength("ISA09", this.nextField(), 6);
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getDate(), controlDate);
        String controlTime = this.checkFixedLength("ISA10", this.nextField(), 4);
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getTime(), controlTime);
        int separator = this.getTokenizer().getRepetitionSeparator();
        if (separator == -1) {
            String standardsId = this.checkFixedLength("ISA11", this.nextField(), 1);
            this.getInterchangeAttributes().addCDATA(this.getXMLTags().getStandardsId(), standardsId);
        } else {
            this.getTokenizer().setRepetitionSeparator(-1);
            this.checkFixedLength("ISA11", this.nextField(), 1);
            this.getTokenizer().setRepetitionSeparator(separator);
        }
        String versionId = this.checkFixedLength("ISA12", this.nextField(), 5);
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getVersion(), versionId);
        String controlNumber = this.checkFixedLength("ISA13", this.nextField(), 9);
        this.setInterchangeControlNumber(controlNumber);
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getControl(), this.getInterchangeControlNumber());
        String ackRequest = this.checkFixedLength("ISA14", this.nextField(), 1);
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getAcknowledgementRequest(), ackRequest);
        String testIndicator = this.checkFixedLength("ISA15", this.nextField(), 1);
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getTestIndicator(), testIndicator);
        if (this.getSubDelimiter() == '\u0000' && !this.recover(syntaxException = new ISA16SubElementDelimiterException())) {
            throw syntaxException;
        }
        while (this.getTokenizer().nextToken().getType() != Token.TokenType.SEGMENT_END) {
            if (this.getTokenizer().getElementInSegmentCount() <= 30) continue;
            se = new EDISyntaxException("Too many fields for an ISA (Segment terminator problem?)", this.getTokenizer());
            logger.warn(se.getMessage());
            throw se;
        }
        if (this.isIncludeSyntaxCharacters()) {
            char repetitionSeparator = this.getRepetitionSeparator();
            if (repetitionSeparator > '\u0000') {
                this.getInterchangeAttributes().addCDATA(this.getXMLTags().getRepetitionSeparator(), String.valueOf(repetitionSeparator));
            }
            this.getInterchangeAttributes().addCDATA(this.getXMLTags().getElementDelimiter(), String.valueOf(this.getDelimiter()));
            this.getInterchangeAttributes().addCDATA(this.getXMLTags().getSubElementDelimiter(), String.valueOf(this.getSubDelimiter()));
            this.getInterchangeAttributes().addCDATA(this.getXMLTags().getSegmentTerminator(), String.valueOf(this.getTerminator()));
        }
        this.startInterchange(this.getInterchangeAttributes());
        this.getInterchangeAttributes().clear();
        this.startElement(this.getXMLTags().getSenderTag(), this.getInterchangeAttributes());
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getIdAttribute(), fromId);
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getQualifierAttribute(), fromQual);
        this.startSenderAddress(this.getInterchangeAttributes());
        this.endElement(this.getXMLTags().getAddressTag());
        this.endElement(this.getXMLTags().getSenderTag());
        this.getInterchangeAttributes().clear();
        this.startElement(this.getXMLTags().getReceiverTag(), this.getInterchangeAttributes());
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getIdAttribute(), toId);
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getQualifierAttribute(), toQual);
        this.startReceiverAddress(this.getInterchangeAttributes());
        this.endElement(this.getXMLTags().getAddressTag());
        this.endElement(this.getXMLTags().getReceiverTag());
        block11: while (true) {
            String sType;
            if ((token = this.getTokenizer().nextToken()).getType() != Token.TokenType.SEGMENT_START) {
                se = new EDISyntaxException("Invalid beginning of segment", this.getTokenizer().getSegmentCount());
                logger.warn(se.getMessage());
                throw se;
            }
            switch (sType = token.getValue()) {
                case "GS": {
                    this.setGroupCount(1 + this.getGroupCount());
                    this.parseFunctionalGroup(token);
                    break;
                }
                case "TA1": {
                    this.parseTA1(token);
                    break;
                }
                case "IEA": {
                    break block11;
                }
                default: {
                    EDISyntaxException se2 = new EDISyntaxException("Unexpected segment type in this context", "IEA or GS", sType, this.getTokenizer());
                    logger.warn(se2.getMessage());
                    throw se2;
                }
            }
        }
        this.checkGroupCount(this.getGroupCount(), this.getTokenizer().nextIntValue(true), "Functional group count error in IEA segment");
        String ieaControlNumber = this.nextField();
        if (ieaControlNumber == null) {
            ieaControlNumber = "(omitted)";
        }
        this.checkInterchangeControlNumber(this.getInterchangeControlNumber(), ieaControlNumber, "Control number error in IEA segment");
        this.getAckGenerator().generateAcknowledgementWrapup();
        this.getAlternateAckGenerator().generateAcknowledgementWrapup();
        this.endInterchange();
        return this.getTokenizer().skipSegment();
    }

    private String nextField() throws SAXException, IOException {
        return this.getTokenizer().nextSimpleValue(false, true);
    }

    private String checkFixedLength(String elementName, String value, int expectedLength) throws EDISyntaxException {
        if (value == null) {
            throw new EDISyntaxException("ISA segment requires 16 instances of the field delimiter", this.getTokenizer());
        }
        if (value.length() != expectedLength) {
            ISAFixedLengthException re = new ISAFixedLengthException(elementName, expectedLength, value.length(), this.getTokenizer());
            this.setSyntaxException(re);
            if (!this.recover(re)) {
                throw re;
            }
            value = FixedLength.valueOf(value, expectedLength);
        }
        return value;
    }

    protected void parseTA1(Token token) throws SAXException, IOException {
        EDIAttributes attributes = new EDIAttributes();
        String acknowledgedControlNumber = this.getTokenizer().nextSimpleValue();
        attributes.addCDATA(this.getXMLTags().getControl(), acknowledgedControlNumber);
        String acknowledgedDate = this.getTokenizer().nextSimpleValue();
        attributes.addCDATA(this.getXMLTags().getDate(), acknowledgedDate);
        String acknowledgedTime = this.getTokenizer().nextSimpleValue();
        attributes.addCDATA(this.getXMLTags().getTime(), acknowledgedTime);
        String code = this.getTokenizer().nextSimpleValue();
        attributes.addCDATA(this.getXMLTags().getAcknowledgementCode(), code);
        String note = this.nextField();
        if (note != null) {
            if (note.length() > 0) {
                attributes.addCDATA(this.getXMLTags().getNotCode(), note);
            }
            this.getTokenizer().skipSegment();
        }
        this.startElement(this.getXMLTags().getAcknowledgementTag(), attributes);
        this.endElement(this.getXMLTags().getAcknowledgementTag());
    }

    protected Token parseFunctionalGroup(Token token) throws SAXException, IOException {
        int docCount = 0;
        this.getGroupAttributes().clear();
        this.groupFunctionCode = this.getTokenizer().nextSimpleValue(false);
        this.getGroupAttributes().addCDATA(this.getXMLTags().getGroupType(), this.groupFunctionCode);
        this.groupSender = this.getTokenizer().nextSimpleValue(false);
        this.process("GS02", this.groupSender);
        this.groupReceiver = this.getTokenizer().nextSimpleValue(false);
        this.process("GS03", this.groupReceiver);
        this.groupDate = this.getTokenizer().nextSimpleValue(false);
        this.getGroupAttributes().addCDATA(this.getXMLTags().getApplSender(), this.groupSender);
        this.getGroupAttributes().addCDATA(this.getXMLTags().getApplReceiver(), this.groupReceiver);
        this.getGroupAttributes().addCDATA(this.getXMLTags().getDate(), this.groupDate);
        String value = "";
        try {
            value = this.getTokenizer().nextSimpleValue();
        }
        catch (EDISyntaxException e) {
            if (e.getMessage().startsWith("Mandatory")) {
                MissingMandatoryElementException missingMandatoryElementException = new MissingMandatoryElementException("Mandatory element missing", "at least one non-space character", "(empty)", this.getTokenizer());
                this.setSyntaxException(missingMandatoryElementException);
                if (!this.recover(missingMandatoryElementException)) {
                    logger.warn(missingMandatoryElementException.getMessage());
                    throw missingMandatoryElementException;
                }
            }
            logger.warn(e.getMessage());
            throw e;
        }
        this.getGroupAttributes().addCDATA(this.getXMLTags().getTime(), value);
        this.setGroupControlNumber(this.getTokenizer().nextSimpleValue(false));
        this.getGroupAttributes().addCDATA(this.getXMLTags().getControl(), this.getGroupControlNumber());
        this.getGroupAttributes().addCDATA(this.getXMLTags().getStandardCode(), this.getTokenizer().nextSimpleValue(false));
        Token t = this.getTokenizer().nextToken();
        if (t.getType() == Token.TokenType.SEGMENT_END) {
            this.groupVersion = "";
        } else {
            this.groupVersion = t.getValue();
            this.getGroupAttributes().addCDATA(this.getXMLTags().getStandardVersion(), this.groupVersion);
            this.getTokenizer().skipSegment();
        }
        this.startElement(this.getXMLTags().getGroupTag(), this.getGroupAttributes());
        this.getAckGenerator().generateAcknowledgmentHeader(this.getFirstSegment(), this.groupSender, this.groupReceiver, this.groupDate.length(), this.groupVersion, this.groupFunctionCode, this.getGroupControlNumber());
        this.getAlternateAckGenerator().generateAcknowledgmentHeader(this.getFirstSegment(), this.groupSender, this.groupReceiver, this.groupDate.length(), this.groupVersion, this.groupFunctionCode, this.getGroupControlNumber());
        block10: while (true) {
            String sType;
            if ((token = this.getTokenizer().nextToken()).getType() != Token.TokenType.SEGMENT_START) {
                EDISyntaxException se = new EDISyntaxException("Invalid beginning of segment", this.getTokenizer().getSegmentCount());
                logger.warn(se.getMessage());
                throw se;
            }
            switch (sType = token.getValue()) {
                case "ST": {
                    ++docCount;
                    this.parseDocument(token);
                    break;
                }
                case "GE": {
                    break block10;
                }
                default: {
                    EDISyntaxException se = new EDISyntaxException("Unexpected segment type in this context", "GE or ST", sType, this.getTokenizer());
                    logger.warn(se.getMessage());
                    throw se;
                }
            }
        }
        this.checkTransactionCount(docCount, this.getTokenizer().nextIntValue(true), "Transaction count error in GE segment");
        String groupControlNumber = this.nextField();
        if (groupControlNumber == null) {
            groupControlNumber = "(omitted)";
        }
        this.checkGroupControlNumber(this.getGroupControlNumber(), groupControlNumber, "Control number error in GE segment");
        this.endElement(this.getXMLTags().getGroupTag());
        this.getAckGenerator().generateGroupAcknowledgmentTrailer(docCount);
        this.getAlternateAckGenerator().generateGroupAcknowledgmentTrailer(docCount);
        return this.getTokenizer().skipSegment();
    }

    protected void process(String ediElement, String value) throws SAXException {
    }

    protected Token parseDocument(Token token) throws SAXException, IOException {
        String segmentType;
        int segCount = 2;
        if (this.getTransactionCallback() != null) {
            this.getTransactionCallback().startTransaction(token.getValue());
        }
        this.getDocumentAttributes().clear();
        String documentType = this.getTokenizer().nextSimpleValue(false);
        this.getDocumentAttributes().addCDATA(this.getXMLTags().getDocumentType(), documentType);
        logger.info("Parsing {} transaction", (Object)documentType);
        String version = this.groupVersion;
        if (version.length() > 6) {
            version = version.substring(0, 6);
        }
        String code = this.getGroupAttributes().getValue(this.getXMLTags().getStandardCode());
        PluginController pluginController = this.getPluginControllerFactory().create("ANSI", documentType, code, version, this.getTokenizer());
        boolean wrapped = this.wrapContentHandlerIfNeeded(pluginController);
        if (pluginController.isEnabled()) {
            this.getDocumentAttributes().addCDATA(this.getXMLTags().getName(), pluginController.getDocumentName());
        }
        String control = this.nextField();
        boolean hitSegmentEnd = false;
        if (control == null) {
            hitSegmentEnd = true;
            control = "";
        }
        this.getDocumentAttributes().addCDATA(this.getXMLTags().getControl(), control);
        if (!hitSegmentEnd) {
            Token st03Token = this.getTokenizer().nextToken();
            switch (st03Token.getType()) {
                case SEGMENT_END: {
                    break;
                }
                case SIMPLE: {
                    this.getDocumentAttributes().addCDATA(this.getXMLTags().getMessageVersion(), st03Token.getValue());
                }
                default: {
                    this.getTokenizer().skipSegment();
                }
            }
        }
        this.startMessage(this.getDocumentAttributes());
        while (!(segmentType = this.getTokenizer().nextSegment()).equals("SE")) {
            if (AnsiReader.isEnvelopeSegment(segmentType)) {
                EDISyntaxException se = new EDISyntaxException("Transaction must be terminated with an SE segment", this.getTokenizer());
                logger.warn(se.getMessage());
                throw se;
            }
            ++segCount;
            if ("BIN".equals(segmentType)) {
                this.parseBINSequence();
                continue;
            }
            this.parseSegment(pluginController, segmentType);
        }
        if (wrapped) {
            this.unwrapContentHandler(pluginController);
        }
        for (int toClose = pluginController.getNestingLevel(); toClose > 0; --toClose) {
            this.endElement(this.getXMLTags().getLoopTag());
        }
        this.checkSegmentCount(segCount, this.getTokenizer().nextIntValue(true), "Segment count error in SE segment");
        this.checkTransactionControlNumber(control, this.nextField(), "Control number error in SE segment");
        this.getAckGenerator().generateTransactionAcknowledgment(documentType, control);
        this.getAlternateAckGenerator().generateTransactionAcknowledgment(documentType, control);
        this.endElement(this.getXMLTags().getDocumentTag());
        Token t = this.getTokenizer().skipSegment();
        if (this.getTransactionCallback() != null) {
            this.getTransactionCallback().endTransaction();
        }
        return t;
    }

    private boolean wrapContentHandlerIfNeeded(PluginController pluginController) {
        boolean result = false;
        ContentHandler contentHandler = this.getContentHandler();
        if (!(contentHandler instanceof QueuedContentHandler) && pluginController.isQueuedContentHandlerRequired()) {
            this.setContentHandler(new QueuedContentHandler(contentHandler, 10, this.getTokenizer()));
            result = true;
        }
        return result;
    }

    private void unwrapContentHandler(PluginController pluginController) {
        ContentHandler contentHandler = this.getContentHandler();
        if (contentHandler instanceof QueuedContentHandler) {
            QueuedContentHandler queuedContentHandler = (QueuedContentHandler)contentHandler;
            try {
                queuedContentHandler.drainQueue();
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            this.setContentHandler(queuedContentHandler.getWrappedContentHandler());
        }
    }

    public static boolean isEnvelopeSegment(String segmentType) {
        return "ISA".equals(segmentType) || "GS".equals(segmentType) || "ST".equals(segmentType) || "SE".equals(segmentType) || "GE".equals(segmentType) || "IEA".equals(segmentType) || "TA1".equals(segmentType);
    }

    protected void parseBINSequence() throws SAXException, IOException {
        int length;
        String lengthField = "";
        try {
            lengthField = this.parseStringFromNextElement();
            length = Integer.parseInt(lengthField);
        }
        catch (EDISyntaxException e) {
            EDISyntaxException se = new EDISyntaxException("BIN segment missing mandatory length field", this.getTokenizer());
            logger.warn(se.getMessage());
            throw se;
        }
        catch (NumberFormatException e) {
            EDISyntaxException se = new EDISyntaxException("BIN object length must be numeric instead of " + lengthField, this.getTokenizer());
            logger.warn(se.getMessage());
            throw se;
        }
        char[] dataObject = this.getTokenizer().getChars(length);
        this.getTokenizer().nextToken();
        this.getDocumentAttributes().clear();
        this.startElement(this.getXMLTags().getPackageTag(), this.getDocumentAttributes());
        new ContentHandlerBase64Encoder().encode(dataObject, this.getContentHandler());
        this.endElement(this.getXMLTags().getPackageTag());
    }

    @Override
    public void preview() throws EDISyntaxException, IOException {
        if (this.isPreviewed()) {
            logger.warn("End-of-file hit multiple times (internal error)");
            throw new EDISyntaxException("End-of-file hit multiple times (internal error)");
        }
        this.setRelease(-1);
        char[] buf = this.getTokenizer().lookahead(128);
        if (buf == null || buf.length < 128) {
            logger.warn("Incomplete ANSI X.12 interchange");
            throw new EDISyntaxException("Incomplete ANSI X.12 interchange");
        }
        if (buf[0] != 'I' || buf[1] != 'S' || buf[2] != 'A') {
            logger.warn("ANSI X.12 interchange must begin with ISA");
            throw new EDISyntaxException("ANSI X.12 interchange must begin with ISA");
        }
        char c = buf[3];
        this.setDelimiter(c);
        int indexOf16thFieldSeparator = AnsiReader.indexOf(c, buf, 16);
        if (indexOf16thFieldSeparator < 0) {
            logger.warn("ISA segment requires 16 instances of the field delimiter");
            throw new EDISyntaxException("ISA segment requires 16 instances of the field delimiter");
        }
        c = buf[indexOf16thFieldSeparator + 1];
        if (this.isAcceptable(c)) {
            this.setSubDelimiter(c);
        } else {
            logger.warn("Invalid ISA16 sub-element delimiter");
        }
        c = buf[indexOf16thFieldSeparator + 2];
        if (!this.isAcceptable(c)) {
            logger.warn("Invalid segment terminator");
            throw new EDISyntaxException("Invalid segment terminator");
        }
        this.setTerminator(c);
        this.setTerminatorSuffix(AnsiReader.findTerminatorSuffix(buf, indexOf16thFieldSeparator + 3, 128));
        int indexOf11thFieldSeparator = AnsiReader.indexOf(this.getDelimiter(), buf, 11);
        char repetitionChar = buf[indexOf11thFieldSeparator + 1];
        if (Character.isLetterOrDigit(repetitionChar) || repetitionChar == this.getTerminator() || repetitionChar == this.getDelimiter() || Character.isWhitespace(repetitionChar)) {
            this.setRepetitionSeparator('\u0000');
        } else {
            this.setRepetitionSeparator(repetitionChar);
        }
        this.setFirstSegment(new String(buf, 0, indexOf16thFieldSeparator + 3));
        this.setPreviewed(true);
    }

    private static int indexOf(char c, char[] buf, int n) {
        int result = -1;
        int count = 0;
        for (int i = 0; i < buf.length; ++i) {
            if (buf[i] != c || ++count != n) continue;
            result = i;
            break;
        }
        return result;
    }

    protected boolean isAcceptable(char c) {
        if (Character.isSpaceChar(c) || Character.isLetter(c) || Character.isDigit(c)) {
            return false;
        }
        if (this.getDelimiter() == c) {
            return false;
        }
        if (this.getRepetitionSeparator() != '\u0000' && this.getRepetitionSeparator() == c) {
            return false;
        }
        if (this.getSubDelimiter() != '\u0000' && this.getSubDelimiter() == c) {
            return false;
        }
        return this.getTerminator() == '\u0000' || this.getTerminator() != c;
    }

    protected static String findTerminatorSuffix(char[] buf, int i, int j) {
        StringBuilder result = new StringBuilder();
        for (int n = i; n < j && !Character.isLetter(buf[n]); ++n) {
            result.append(buf[n]);
        }
        return result.toString();
    }

    @Override
    public ReplyGenerator getAckGenerator() {
        if (super.getAckGenerator() == null) {
            this.setAckGenerator(new AnsiFAGenerator(this, this.getAckStream()));
        }
        return super.getAckGenerator();
    }

    @Override
    public ReplyGenerator getAlternateAckGenerator() {
        if (super.getAlternateAckGenerator() == null) {
            this.setAlternateAckGenerator(new Ansi999Generator(this, this.getAlternateAckStream()));
        }
        return super.getAlternateAckGenerator();
    }
}

