/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader;

import com.berryworks.edireader.DefaultXMLTags;
import com.berryworks.edireader.EDIAbstractReader;
import com.berryworks.edireader.EDIReaderFactory;
import com.berryworks.edireader.EDISyntaxException;
import com.berryworks.edireader.XMLTags;
import com.berryworks.edireader.error.ErrorMessages;
import com.berryworks.edireader.plugin.PluginControllerFactoryInterface;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class EDIReader
extends EDIAbstractReader
implements ErrorMessages {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getSimpleName());
    private EDIReader theReader;
    private XMLTags xmlTags;
    private PluginControllerFactoryInterface pluginControllerFactory;

    @Override
    public void preview() throws EDISyntaxException, IOException {
        throw new EDISyntaxException("EDIReader.preview() called unexpectedly");
    }

    @Override
    public void parse(InputSource source) throws SAXException, IOException {
        this.startXMLDocument();
        char[] leftOver = null;
        while (true) {
            if (this.theReader == null) {
                this.theReader = EDIReaderFactory.createEDIReader(source, leftOver);
                if (this.theReader == null) break;
                logger.info("Created an EDIReader of type {}", (Object)this.theReader.getClass().getName());
                this.theReader.setExternalXmlDocumentStart(true);
                this.theReader.setAcknowledgment(this.getAckStream());
                this.theReader.setAlternateAcknowledgment(this.getAlternateAckStream());
                this.theReader.setContentHandler(this.getContentHandler());
                this.theReader.setSyntaxExceptionHandler(this.getSyntaxExceptionHandler());
                this.theReader.setNamespaceEnabled(this.isNamespaceEnabled());
                this.theReader.setIncludeSyntaxCharacters(this.isIncludeSyntaxCharacters());
                this.theReader.setKeepSpacesOnlyElements(this.isKeepSpacesOnlyElements());
            }
            this.theReader.setXMLTags(this.xmlTags);
            if (this.pluginControllerFactory != null) {
                this.theReader.setPluginControllerFactory(this.pluginControllerFactory);
            }
            this.theReader.parse(source);
            this.setDelimiter(this.theReader.getDelimiter());
            this.setSubDelimiter(this.theReader.getSubDelimiter());
            this.setSubSubDelimiter(this.theReader.getSubSubDelimiter());
            this.setRepetitionSeparator(this.theReader.getRepetitionSeparator());
            this.setRelease(this.theReader.getRelease());
            this.setDecimalMark(this.theReader.getDecimalMark());
            this.setTerminator(this.theReader.getTerminator());
            this.setTerminatorSuffix(this.theReader.getTerminatorSuffix());
            leftOver = this.theReader.getTokenizer().getBuffered();
            this.theReader = null;
        }
        logger.debug("EDIReader.parse(InputSource) hit end of input");
        this.endXMLDocument();
    }

    public void setXMLTags(XMLTags tags) {
        this.xmlTags = tags;
    }

    public XMLTags getXMLTags() {
        if (this.xmlTags == null) {
            this.xmlTags = DefaultXMLTags.getInstance();
        }
        return this.xmlTags;
    }

    public void setPluginControllerFactory(PluginControllerFactoryInterface pluginControllerFactory) {
        this.pluginControllerFactory = pluginControllerFactory;
    }

    protected void startXMLDocument() throws SAXException {
        AttributesImpl attrList = new AttributesImpl();
        attrList.clear();
        ContentHandler contentHandler = this.getContentHandler();
        if (contentHandler == null) {
            throw new SAXException("No ContentHandler configured for EDIReader");
        }
        contentHandler.startDocument();
        String rootTag = this.getXMLTags().getRootTag();
        if (this.isNamespaceEnabled()) {
            contentHandler.startElement("http://www.berryworkssoftware.com/2008/edireader", rootTag, rootTag, attrList);
        } else {
            this.startElement(rootTag, attrList);
        }
    }

    protected void endXMLDocument() throws SAXException {
        this.endElement(this.getXMLTags().getRootTag());
        this.getContentHandler().endDocument();
    }

    protected void startElement(String tag, Attributes attributes) throws SAXException {
        this.getContentHandler().startElement("", tag, tag, attributes);
    }

    protected void endElement(String tag) throws SAXException {
        this.getContentHandler().endElement("", tag, tag);
    }
}

