/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader;

import com.berryworks.edireader.EdifactReaderWithCONTRL;
import com.berryworks.edireader.ReplyGenerator;
import com.berryworks.edireader.StandardReader;
import com.berryworks.edireader.util.DateTimeGenerator;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;

public class EdifactCONTRLGenerator
extends ReplyGenerator {
    private final Writer ackStream;
    private char delimiter;
    private char subDelimiter;
    private String segmentTerminator;
    private String syntaxIdentifier;
    private String versionNumber;
    private String interchangeControlNumber;
    private int segmentCount;
    private String interchangeSender;
    private String interchangeSenderQualifier;
    private String interchangeRecipient;
    private String interchangeRecipientQualifier;
    private String generatedInterchangeControlNumber;
    private int generatedMessageNumber;
    private boolean generated;

    public EdifactCONTRLGenerator(StandardReader standardReader, Writer ackStream) {
        this.standardReader = standardReader;
        this.ackStream = ackStream;
    }

    public void generateAcknowledgmentHeader(Attributes attributes) {
        if (this.ackStream == null) {
            return;
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if (this.standardReader.getXMLTags().getControl().equals(name)) {
                this.interchangeControlNumber = value;
                continue;
            }
            if (this.standardReader.getXMLTags().getSyntaxIdentifier().equals(name)) {
                this.syntaxIdentifier = value;
                continue;
            }
            if (!this.standardReader.getXMLTags().getSyntaxVersion().equals(name)) continue;
            this.versionNumber = value;
        }
    }

    public void setSender(Attributes attributes) {
        if (this.ackStream == null) {
            return;
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if (this.standardReader.getXMLTags().getIdAttribute().equals(name)) {
                this.interchangeSender = value;
                continue;
            }
            if (!this.standardReader.getXMLTags().getQualifierAttribute().equals(name)) continue;
            this.interchangeSenderQualifier = value;
        }
    }

    public void setReceiver(Attributes attributes) {
        if (this.ackStream == null) {
            return;
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if (this.standardReader.getXMLTags().getIdAttribute().equals(name)) {
                this.interchangeRecipient = value;
                continue;
            }
            if (!this.standardReader.getXMLTags().getQualifierAttribute().equals(name)) continue;
            this.interchangeRecipientQualifier = value;
        }
    }

    @Override
    public void generateAcknowledgmentHeader(String xsyntaxIdentifier, String xversionNumber, String xsender, String xsenderQualifier, String xrecipient, String xrecipientQualifier, String xcontrolNumber) {
    }

    public void generateTransactionAcknowledgment(Attributes attributes) throws IOException {
        String messageReference;
        String messageVersionNumber = "D";
        String messageReleaseNumber = "97B";
        String controllingAgency = "UN";
        if (this.ackStream == null) {
            return;
        }
        if (!this.generated) {
            EdifactReaderWithCONTRL reader;
            this.generated = true;
            this.delimiter = this.standardReader.getDelimiter();
            this.subDelimiter = this.standardReader.getSubDelimiter();
            char terminator = this.standardReader.getTerminator();
            String terminatorSuffix = this.standardReader.getTerminatorSuffix();
            this.segmentTerminator = terminator + terminatorSuffix;
            char repetitionCharacter = this.standardReader.getRepetitionSeparator();
            if (repetitionCharacter == '\u0000') {
                repetitionCharacter = ' ';
            }
            String dateAndTime = this.controlDateAndTimeOverride == null ? DateTimeGenerator.generate(this.subDelimiter) : this.controlDateAndTimeOverride;
            if (this.standardReader instanceof EdifactReaderWithCONTRL && (reader = (EdifactReaderWithCONTRL)this.standardReader).isUNA()) {
                int ri = this.standardReader.getRelease();
                char r = (char)(ri < 0 ? 32 : (char)ri);
                this.ackStream.write("UNA" + this.subDelimiter + this.delimiter + reader.getDecimalMark() + r + repetitionCharacter + this.segmentTerminator);
            }
            this.generatedInterchangeControlNumber = this.interchangeControlNumber;
            this.ackStream.write("UNB" + this.delimiter + this.syntaxIdentifier + this.subDelimiter + this.versionNumber + this.delimiter + this.interchangeRecipient + this.subDelimiter + this.interchangeRecipientQualifier + this.delimiter + this.interchangeSender + this.subDelimiter + this.interchangeSenderQualifier + this.delimiter + dateAndTime + this.delimiter + this.generatedInterchangeControlNumber);
            this.ackStream.write(this.segmentTerminator);
            for (int i = 0; i < attributes.getLength(); ++i) {
                String name = attributes.getLocalName(i);
                String value = attributes.getValue(i);
                if (this.standardReader.getXMLTags().getMessageVersion().equals(name)) {
                    messageVersionNumber = value;
                    continue;
                }
                if (this.standardReader.getXMLTags().getMessageRelease().equals(name)) {
                    messageReleaseNumber = value;
                    continue;
                }
                if (!this.standardReader.getXMLTags().getAgency().equals(name)) continue;
                controllingAgency = value;
            }
            this.ackStream.write("UNH" + this.delimiter + ++this.generatedMessageNumber + this.delimiter + "CONTRL" + this.subDelimiter + messageVersionNumber + this.subDelimiter + messageReleaseNumber + this.subDelimiter + controllingAgency);
            this.ackStream.write(this.segmentTerminator);
            ++this.segmentCount;
            this.ackStream.write("UCI" + this.delimiter + this.interchangeControlNumber + this.delimiter + this.interchangeSender + this.subDelimiter + this.interchangeSenderQualifier + this.delimiter + this.interchangeRecipient + this.subDelimiter + this.interchangeRecipientQualifier + this.delimiter + "7");
            this.ackStream.write(this.segmentTerminator);
            ++this.segmentCount;
        }
        if ((messageReference = attributes.getValue(this.standardReader.getXMLTags().getControl())) != null) {
            this.ackStream.write("UCM" + this.delimiter + messageReference);
            String messageType = attributes.getValue(this.standardReader.getXMLTags().getDocumentType());
            if (messageType != null) {
                this.ackStream.write(this.delimiter + messageType);
                String mvn = attributes.getValue(this.standardReader.getXMLTags().getVersion());
                if (mvn != null) {
                    this.ackStream.write(this.subDelimiter + mvn);
                    String release = attributes.getValue(this.standardReader.getXMLTags().getRelease());
                    if (release != null) {
                        this.ackStream.write(this.subDelimiter + release);
                        String agency = attributes.getValue(this.standardReader.getXMLTags().getAgency());
                        if (agency != null) {
                            this.ackStream.write(this.subDelimiter + agency);
                            String association = attributes.getValue(this.standardReader.getXMLTags().getAssociation());
                            if (association != null) {
                                this.ackStream.write(this.subDelimiter + association);
                            }
                        }
                    }
                }
            }
            this.ackStream.write(this.delimiter + "7" + this.segmentTerminator);
            ++this.segmentCount;
        }
    }

    @Override
    public void generateTransactionAcknowledgment(String transactionCode, String controlNumber) throws IOException {
    }

    @Override
    public void generateGroupAcknowledgmentTrailer(int docCount) throws IOException {
    }

    @Override
    public void generateNegativeACK() {
    }

    @Override
    public void generateAcknowledgementWrapup() throws IOException {
        if (this.ackStream == null) {
            return;
        }
        ++this.segmentCount;
        this.ackStream.write("UNT" + this.delimiter + this.segmentCount + this.delimiter + this.generatedMessageNumber);
        this.ackStream.write(this.segmentTerminator);
        this.ackStream.write("UNZ" + this.delimiter + "1" + this.delimiter + this.generatedInterchangeControlNumber);
        this.ackStream.write(this.segmentTerminator);
        this.ackStream.close();
    }

    @Override
    public void generateAcknowledgmentHeader(String firstSegment, String groupSender, String groupReceiver, int i, String groupVersion, String groupFunctionCode, String groupControlNumber) throws IOException {
    }
}

