/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader;

import com.berryworks.edireader.EDIStandard;
import com.berryworks.edireader.EDISyntaxException;
import com.berryworks.edireader.PluginController;
import com.berryworks.edireader.StandardReader;
import com.berryworks.edireader.tokenizer.Token;
import com.berryworks.edireader.util.ContentHandlerBase64Encoder;
import com.berryworks.edireader.util.FixedLength;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class EdifactReader
extends StandardReader {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getSimpleName());
    protected static final int ELEMENTS_IN_SEGMENT_MAXIMUM = 50;
    protected static final int ELEMENTS_IN_UNB_MAXIMUM = 30;
    protected boolean ungExplicit;
    protected boolean witnessedUNA;

    @Override
    protected Token recognizeBeginning() throws IOException, SAXException {
        Token t = this.getTokenizer().nextToken();
        if (t.getType() == Token.TokenType.SEGMENT_START) {
            String segType = t.getValue();
            if ("UNA".equals(segType)) {
                this.witnessedUNA = true;
                this.getTokenizer().skipSegment();
                t = this.getTokenizer().nextToken();
                if (t.getType() == Token.TokenType.SEGMENT_START) {
                    segType = t.getValue();
                } else {
                    EDISyntaxException se = new EDISyntaxException("Improperly formed UNA segment", this.getTokenizer());
                    logger.warn(se.getMessage());
                    throw se;
                }
            }
            if (!"UNB".equals(segType)) {
                if (this.witnessedUNA) {
                    String msg = "Mandatory UNB segment was not recognized after UNA. Terminator problem?";
                    logger.warn(msg);
                    throw new EDISyntaxException(msg);
                }
                EDISyntaxException se = new EDISyntaxException("First segment must be UNA or UNB", this.getTokenizer());
                logger.warn(se.getMessage());
                throw se;
            }
        } else {
            logger.warn("First segment must be UNA or UNB");
            throw new EDISyntaxException("First segment must be UNA or UNB");
        }
        return t;
    }

    @Override
    protected Token parseInterchange(Token token) throws SAXException, IOException {
        this.getInterchangeAttributes().clear();
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getStandard(), EDIStandard.EDIFACT.getDisplayName());
        this.setGroupCount(0);
        List<String> compositeList = this.getTokenizer().nextCompositeElement();
        String syntaxIdentifier = this.getSubElement(compositeList, 0);
        String syntaxVersionNumber = this.getSubElement(compositeList, 1);
        if (syntaxIdentifier.length() > 0) {
            this.getInterchangeAttributes().addCDATA(this.getXMLTags().getSyntaxIdentifier(), syntaxIdentifier);
            if (syntaxVersionNumber.length() > 0) {
                this.getInterchangeAttributes().addCDATA(this.getXMLTags().getSyntaxVersion(), syntaxVersionNumber);
            }
        }
        compositeList = this.getTokenizer().nextCompositeElement();
        String fromId = this.getSubElement(compositeList, 0);
        String fromQual = this.getSubElement(compositeList, 1);
        String fromExtra = this.getSubElement(compositeList, 2);
        compositeList = this.getTokenizer().nextCompositeElement();
        String toId = this.getSubElement(compositeList, 0);
        String toQual = this.getSubElement(compositeList, 1);
        String toExtra = this.getSubElement(compositeList, 2);
        compositeList = this.getTokenizer().nextCompositeElement();
        String date = this.getSubElement(compositeList, 0);
        String time = this.getSubElement(compositeList, 1);
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getDate(), date);
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getTime(), time);
        this.setInterchangeControlNumber(this.getTokenizer().nextSimpleValue());
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getControl(), this.getInterchangeControlNumber());
        this.remainderOfUNB();
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getDecimal(), String.valueOf(this.getDecimalMark()));
        this.startInterchange(this.getInterchangeAttributes());
        this.generatedSenderAndReceiver(fromId, fromQual, fromExtra, toId, toQual, toExtra);
        block10: while (true) {
            String sType;
            this.ungExplicit = true;
            token = this.getTokenizer().nextToken();
            if (token.getType() != Token.TokenType.SEGMENT_START) {
                EDISyntaxException se = new EDISyntaxException("Invalid beginning of UNG|UNH|UNZ segment", this.getTokenizer());
                logger.warn(se.getMessage());
                throw se;
            }
            switch (sType = token.getValue()) {
                case "UNG": {
                    this.setGroupCount(1 + this.getGroupCount());
                    this.parseFunctionalGroup(token);
                    break;
                }
                case "UNH": {
                    this.impliedFunctionalGroup(token);
                    break;
                }
                case "UNZ": {
                    break block10;
                }
                default: {
                    EDISyntaxException se = new EDISyntaxException("Unexpected segment type in this context", "UNH, UNZ, or UNG", sType, this.getTokenizer());
                    logger.warn(se.getMessage());
                    throw se;
                }
            }
        }
        this.checkGroupCount(this.getGroupCount(), this.getTokenizer().nextIntValue(), "Functional group count error in UNZ segment");
        this.checkInterchangeControlNumber(this.getInterchangeControlNumber(), this.getTokenizer().nextSimpleValue(), "Control number error in UNZ segment");
        this.endInterchange();
        return this.getTokenizer().skipSegment();
    }

    protected void remainderOfUNB() throws IOException, EDISyntaxException {
        if (this.hitEndOfSegment(this.getXMLTags().getRecipientReference()) || this.hitEndOfSegment(this.getXMLTags().getApplicationReference()) || this.hitEndOfSegment(this.getXMLTags().getProcessingPriority()) || this.hitEndOfSegment(this.getXMLTags().getAcknowledgementRequest()) || this.hitEndOfSegment(this.getXMLTags().getInterchangeAgreementIdentifier()) || this.hitEndOfSegment(this.getXMLTags().getTestIndicator())) {
            return;
        }
        while (this.getTokenizer().nextToken().getType() != Token.TokenType.SEGMENT_END) {
            if (this.getTokenizer().getElementInSegmentCount() <= 30) continue;
            EDISyntaxException se = new EDISyntaxException("Too many (" + this.getTokenizer().getElementInSegmentCount() + ") elements for a UNB. Segment terminator problem?", this.getTokenizer());
            logger.warn(se.getMessage());
            throw se;
        }
    }

    protected boolean hitEndOfSegment(String attributeName) throws EDISyntaxException, IOException {
        Token token = this.getTokenizer().nextToken();
        if (token.getType() == Token.TokenType.SEGMENT_END) {
            return true;
        }
        if (token.getType() == Token.TokenType.SIMPLE) {
            this.getInterchangeAttributes().addCDATA(attributeName, token.getValue());
        }
        return false;
    }

    protected Token parseFunctionalGroup(Token token) throws SAXException, IOException {
        int docCount = 0;
        this.getGroupAttributes().clear();
        this.getGroupAttributes().addCDATA("GroupType", this.getTokenizer().nextSimpleValue());
        List<String> compositeList = this.getTokenizer().nextCompositeElement();
        String sender = this.getSubElement(compositeList, 0);
        this.getGroupAttributes().addCDATA(this.getXMLTags().getApplSender(), sender);
        String senderQualifier = this.getSubElement(compositeList, 1);
        if (FixedLength.isPresent(senderQualifier)) {
            this.getGroupAttributes().addCDATA(this.getXMLTags().getApplSenderQualifier(), senderQualifier);
        }
        compositeList = this.getTokenizer().nextCompositeElement();
        String receiver = this.getSubElement(compositeList, 0);
        this.getGroupAttributes().addCDATA(this.getXMLTags().getApplReceiver(), receiver);
        String receiverQualifier = this.getSubElement(compositeList, 1);
        if (FixedLength.isPresent(receiverQualifier)) {
            this.getGroupAttributes().addCDATA(this.getXMLTags().getApplReceiverQualifier(), receiverQualifier);
        }
        compositeList = this.getTokenizer().nextCompositeElement();
        String date = this.getSubElement(compositeList, 0);
        String time = this.getSubElement(compositeList, 1);
        this.getGroupAttributes().addCDATA(this.getXMLTags().getDate(), date);
        this.getGroupAttributes().addCDATA(this.getXMLTags().getTime(), time);
        this.setGroupControlNumber(this.getTokenizer().nextSimpleValue());
        this.getGroupAttributes().addCDATA(this.getXMLTags().getControl(), this.getGroupControlNumber());
        this.getGroupAttributes().addCDATA("StandardCode", this.getTokenizer().nextSimpleValue());
        compositeList = this.getTokenizer().nextCompositeElement();
        String version = this.getSubElement(compositeList, 0);
        String release = this.getSubElement(compositeList, 1);
        this.getGroupAttributes().addCDATA(this.getXMLTags().getStandardVersion(), version + release);
        this.startElement(this.getXMLTags().getGroupTag(), this.getGroupAttributes());
        this.getTokenizer().skipSegment();
        block8: while (true) {
            String sType;
            if ((token = this.getTokenizer().nextToken()).getType() != Token.TokenType.SEGMENT_START) {
                EDISyntaxException se = new EDISyntaxException("Invalid beginning of UNH|UNE segment", this.getTokenizer().getSegmentCount());
                logger.warn(se.getMessage());
                throw se;
            }
            switch (sType = token.getValue()) {
                case "UNH": {
                    ++docCount;
                    this.parseDocument(token);
                    break;
                }
                case "UNE": {
                    break block8;
                }
                default: {
                    EDISyntaxException se = new EDISyntaxException("Expected UNE or UNH segment instead of " + sType, this.getTokenizer());
                    logger.warn(se.getMessage());
                    throw se;
                }
            }
        }
        this.checkTransactionCount(docCount, this.getTokenizer().nextIntValue(), "Message count error in UNE segment");
        this.checkGroupControlNumber(this.getGroupControlNumber(), this.getTokenizer().nextSimpleValue(), "Control number error in UNE segment");
        this.endElement(this.getXMLTags().getGroupTag());
        return this.getTokenizer().skipSegment();
    }

    protected Token impliedFunctionalGroup(Token token) throws SAXException, IOException {
        this.getGroupAttributes().clear();
        this.startElement(this.getXMLTags().getGroupTag(), this.getGroupAttributes());
        block8: while (true) {
            String sType;
            if (token.getType() != Token.TokenType.SEGMENT_START) {
                EDISyntaxException se = new EDISyntaxException("Invalid beginning of UNH|UNZ segment", this.getTokenizer().getSegmentCount());
                logger.warn(se.getMessage());
                throw se;
            }
            switch (sType = token.getValue()) {
                case "UNH": {
                    this.setGroupCount(1 + this.getGroupCount());
                    this.parseDocument(token);
                    token = this.getTokenizer().nextToken();
                    break;
                }
                case "UNZ": {
                    this.getTokenizer().ungetToken();
                    break block8;
                }
                default: {
                    EDISyntaxException se = new EDISyntaxException("Unexpected segment type in this context", "UNH or UNZ", sType, this.getTokenizer());
                    logger.warn(se.getMessage());
                    throw se;
                }
            }
        }
        this.endElement(this.getXMLTags().getGroupTag());
        return token;
    }

    protected Token parseDocument(Token token) throws SAXException, IOException {
        String segmentType;
        PluginController pluginController;
        String accessReference;
        String messageType = "";
        String messageVersion = "";
        String messageRelease = "";
        int segCount = 2;
        this.getDocumentAttributes().clear();
        String control = this.getTokenizer().nextSimpleValue();
        this.getDocumentAttributes().addCDATA(this.getXMLTags().getControl(), control);
        List<String> v = this.getTokenizer().nextCompositeElement();
        if (v != null) {
            int n = v.size();
            String s = v.get(0);
            if (s != null) {
                messageType = s;
                logger.info("Parsing {} message", (Object)messageType);
                this.getDocumentAttributes().addCDATA(this.getXMLTags().getDocumentType(), messageType);
            }
            if (n > 1 && (s = v.get(1)) != null) {
                messageVersion = s;
                this.getDocumentAttributes().addCDATA(this.getXMLTags().getMessageVersion(), messageVersion);
            }
            if (n > 2 && (s = v.get(2)) != null) {
                messageRelease = s;
                this.getDocumentAttributes().addCDATA(this.getXMLTags().getMessageRelease(), messageRelease);
            }
            if (n > 3 && (s = v.get(3)) != null) {
                this.getDocumentAttributes().addCDATA(this.getXMLTags().getAgency(), s);
            }
            if (n > 4 && (s = v.get(4)) != null) {
                this.getDocumentAttributes().addCDATA(this.getXMLTags().getAssociation(), s);
            }
        }
        if (FixedLength.emptyIfNull(accessReference = this.getTokenizer().nextSimpleValue(false, true)).length() > 0) {
            this.getDocumentAttributes().addCDATA(this.getXMLTags().getAccessReference(), accessReference);
        }
        if ((pluginController = this.getPluginControllerFactory().create(EDIStandard.EDIFACT.name(), messageType, messageVersion, messageRelease, this.getTokenizer())).isEnabled()) {
            this.getDocumentAttributes().addCDATA(this.getXMLTags().getName(), pluginController.getDocumentName());
        }
        this.startMessage(this.getDocumentAttributes());
        while (!(segmentType = this.getTokenizer().nextSegment()).equals("UNT")) {
            ++segCount;
            if ("UNO".equals(segmentType)) {
                this.parseUNOUNPSequence();
                ++segCount;
                continue;
            }
            this.parseSegment(pluginController, segmentType);
        }
        for (int toClose = pluginController.getNestingLevel(); toClose > 0; --toClose) {
            this.endElement(this.getXMLTags().getLoopTag());
        }
        this.checkSegmentCount(segCount, this.getTokenizer().nextIntValue(), "Segment count error in UNT segment");
        this.checkTransactionControlNumber(control, this.getTokenizer().nextSimpleValue(), "Control number error in UNT segment");
        this.endElement(this.getXMLTags().getDocumentTag());
        return this.getTokenizer().skipSegment();
    }

    protected void parseUNOUNPSequence() throws SAXException, IOException {
        int length;
        String lengthField = "";
        try {
            lengthField = this.parseStringFromNextElement();
            length = Integer.parseInt(lengthField);
        }
        catch (EDISyntaxException e) {
            EDISyntaxException se = new EDISyntaxException("UNO segment missing mandatory length field", this.getTokenizer());
            logger.warn(se.getMessage());
            throw se;
        }
        catch (NumberFormatException e) {
            EDISyntaxException se = new EDISyntaxException("UNO object length must be numeric instead of " + lengthField, this.getTokenizer());
            logger.warn(se.getMessage());
            throw se;
        }
        String packageReference = this.parseStringFromNextElement();
        this.getTokenizer().skipSegment();
        char[] dataObject = this.getTokenizer().getChars(length);
        Token token = this.getTokenizer().nextToken();
        if (token.getType() == Token.TokenType.SEGMENT_START && "UNP".equals(token.getSegmentType())) {
            int unpLength;
            String unpLengthField = this.parseStringFromNextElement();
            try {
                unpLength = Integer.parseInt(unpLengthField);
            }
            catch (NumberFormatException e) {
                EDISyntaxException se = new EDISyntaxException("UNP object length must be numeric instead of " + unpLengthField);
                logger.warn(se.getMessage());
                throw se;
            }
            if (length != unpLength) {
                EDISyntaxException se = new EDISyntaxException("UNP segment contains length field that does not match length field in UNO", length, unpLength, this.getTokenizer());
                logger.warn(se.getMessage());
                throw se;
            }
            String unpPackageReference = this.parseStringFromNextElement();
            if (unpPackageReference == null || !unpPackageReference.equals(packageReference)) {
                EDISyntaxException se = new EDISyntaxException("UNP segment contains package reference that does not match corresponding reference in UNO", packageReference, unpPackageReference, this.getTokenizer());
                logger.warn(se.getMessage());
                throw se;
            }
        } else {
            EDISyntaxException se = new EDISyntaxException("UNP segment not properly positioned after UNO segment and data object sequence");
            logger.warn(se.getMessage());
            throw se;
        }
        this.getTokenizer().skipSegment();
        this.getDocumentAttributes().clear();
        this.getDocumentAttributes().addCDATA(this.getXMLTags().getIdAttribute(), packageReference);
        this.startElement(this.getXMLTags().getPackageTag(), this.getDocumentAttributes());
        new ContentHandlerBase64Encoder().encode(dataObject, this.getContentHandler());
        this.endElement(this.getXMLTags().getPackageTag());
    }

    @Override
    public void preview() throws EDISyntaxException, IOException {
        char[] buf = this.getTokenizer().lookahead(128);
        if (buf[0] != 'U' || buf[1] != 'N') {
            EDISyntaxException se = new EDISyntaxException("EDIFACT interchange must begin with UN");
            logger.warn(se.getMessage());
            throw se;
        }
        if (this.isPreviewed()) {
            EDISyntaxException se = new EDISyntaxException("Internal error: EDIFACT interchange previewed more than once");
            logger.warn(se.getMessage());
            throw se;
        }
        boolean subDelimiterDetermined = false;
        boolean delimiterDetermined = false;
        boolean releaseDetermined = false;
        boolean decimalMarkDetermined = false;
        boolean terminatorDetermined = false;
        boolean terminatorSuffixDetermined = false;
        this.setTerminatorSuffix("");
        if (buf[2] == 'A') {
            this.setSubDelimiter(buf[3]);
            subDelimiterDetermined = true;
            this.setDelimiter(buf[4]);
            delimiterDetermined = true;
            this.setDecimalMark(buf[5]);
            decimalMarkDetermined = true;
            if (buf[6] == ' ') {
                this.setRelease(-1);
            } else {
                this.setRelease(buf[6]);
            }
            releaseDetermined = true;
            if (buf[7] == ' ') {
                this.setRepetitionSeparator('\u0000');
            } else {
                this.setRepetitionSeparator(buf[7]);
            }
            this.setTerminator(buf[8]);
            terminatorDetermined = true;
            terminatorSuffixDetermined = this.shiftUNBoverUNA(buf);
        }
        if (!(releaseDetermined && subDelimiterDetermined && delimiterDetermined && terminatorDetermined && terminatorSuffixDetermined)) {
            this.previewUNB(buf, delimiterDetermined, subDelimiterDetermined, decimalMarkDetermined, releaseDetermined, terminatorDetermined, terminatorSuffixDetermined);
        }
        this.setPreviewed(true);
    }

    private boolean shiftUNBoverUNA(char[] buf) {
        int j;
        boolean terminatorSuffixDetermined = false;
        int nShift = 9;
        for (j = 9; j < 14; ++j) {
            if (Character.isLetter(buf[j])) {
                nShift = j;
                break;
            }
            this.setTerminatorSuffix(this.getTerminatorSuffix() + buf[j]);
            terminatorSuffixDetermined = true;
        }
        for (j = 0; j < buf.length - nShift; ++j) {
            buf[j] = buf[j + nShift];
        }
        return terminatorSuffixDetermined;
    }

    private void previewUNB(char[] buf, boolean delimiterDetermined, boolean subDelimiterDetermined, boolean decimalMarkDetermined, boolean releaseDetermined, boolean terminatorDetermined, boolean terminatorSuffixDetermined) throws EDISyntaxException {
        if (buf[2] != 'B') {
            EDISyntaxException se = new EDISyntaxException("Required UNB segment not found in EDIFACT interchange");
            logger.warn(se.getMessage());
            throw se;
        }
        char syntaxIdentifier = buf[7];
        switch (syntaxIdentifier) {
            case 'B': {
                if (!delimiterDetermined && buf[3] == '+') break;
                if (!delimiterDetermined) {
                    this.setDelimiter('\u001d');
                    delimiterDetermined = true;
                }
                if (!subDelimiterDetermined) {
                    this.setSubDelimiter('\u001f');
                    subDelimiterDetermined = true;
                }
                if (!terminatorDetermined) {
                    this.setTerminator('\u001c');
                    terminatorDetermined = true;
                }
                this.setRelease(-1);
                releaseDetermined = true;
                this.setRepetitionSeparator('\u0019');
            }
        }
        if (!Character.isLetter(syntaxIdentifier)) {
            EDISyntaxException se = new EDISyntaxException("Unknown Syntax Identifier in UNB segment: " + new String(buf, 4, 4));
            logger.warn(se.getMessage());
            throw se;
        }
        if (!delimiterDetermined) {
            this.setDelimiter('+');
        }
        if (buf[3] != this.getDelimiter()) {
            EDISyntaxException se = new EDISyntaxException("Expected data element separator after UNB segment tag");
            logger.warn(se.getMessage());
            throw se;
        }
        if (!terminatorDetermined) {
            this.setTerminator('\'');
        }
        if (!subDelimiterDetermined) {
            this.setSubDelimiter(':');
        }
        if (!decimalMarkDetermined) {
            this.setDecimalMark('.');
        }
        if (!releaseDetermined) {
            this.setRelease(63);
        }
        if (!terminatorSuffixDetermined) {
            this.setTerminatorSuffix(this.scanForSuffix(buf, 3));
        }
    }

    protected String scanForSuffix(char[] buffer, int index) {
        StringBuilder suffix = new StringBuilder();
        for (int i = index; i < buffer.length; ++i) {
            if (buffer[i] != this.getTerminator()) continue;
            for (int j = 1; j < 3; ++j) {
                if (++i >= buffer.length || Character.isLetter(buffer[i])) continue;
                suffix.append(buffer[i]);
            }
            break;
        }
        return suffix.toString();
    }

    public boolean isUNA() {
        return this.witnessedUNA;
    }
}

