/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader;

import com.berryworks.edireader.AnsiReader;
import com.berryworks.edireader.EDIReader;
import com.berryworks.edireader.EdifactReaderWithCONTRL;
import com.berryworks.edireader.UNHReader;
import java.util.HashMap;
import java.util.Map;

public class ParserRegistry {
    private static final Map<String, Class> builtinClass = new HashMap<String, Class>();
    private static final Map<String, String> registeredClassNames = new HashMap<String, String>();

    private ParserRegistry() {
        builtinClass.put("ISA", AnsiReader.class);
        builtinClass.put("UNA", EdifactReaderWithCONTRL.class);
        builtinClass.put("UNB", EdifactReaderWithCONTRL.class);
        builtinClass.put("UNH", UNHReader.class);
        registeredClassNames.put("UNH", "com.berryworks.edireader.amadeus.AmadeusReader");
        registeredClassNames.put("MSH", "com.berryworks.edireader.hl7.HL7Reader");
        registeredClassNames.put("STX", "com.berryworks.edireader.tradacoms.TradacomsReader");
        registeredClassNames.put("1", "com.berryworks.edireader.ach.ACHReader");
        registeredClassNames.put("AA0", "com.berryworks.edireader.nsf.NSFReader");
    }

    public static EDIReader get(String firstChars) {
        Class<?> parserClass;
        EDIReader result = null;
        String name = (String)ParserRegistry.getMatch(firstChars, registeredClassNames);
        if (name != null) {
            try {
                parserClass = Class.forName(name);
                result = (EDIReader)parserClass.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result == null && (parserClass = (Class<?>)ParserRegistry.getMatch(firstChars, builtinClass)) != null) {
            try {
                result = (EDIReader)parserClass.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result == null && (name = registeredClassNames.get("")) != null) {
            try {
                parserClass = Class.forName(name);
                result = (EDIReader)parserClass.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static void register(String firstChars, String className) {
        registeredClassNames.put(firstChars, className);
    }

    private static Object getMatch(String firstChars, Map map) {
        Object result = null;
        int n = firstChars.length();
        while (result == null && n > 0) {
            result = map.get(firstChars);
            firstChars = firstChars.substring(0, --n);
        }
        return result;
    }

    static {
        new ParserRegistry();
    }
}

