/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader;

import com.berryworks.edireader.plugin.LoopDescriptor;
import com.berryworks.edireader.plugin.PluginControllerImpl;
import com.berryworks.edireader.plugin.PluginPreparation;
import com.berryworks.edireader.tokenizer.Tokenizer;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Plugin {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getSimpleName());
    public static final String ANY_CONTEXT = "*";
    public static final String INITIAL_CONTEXT = "/";
    public static final String CURRENT = ".";
    protected static int pluginsLoaded;
    protected LoopDescriptor[] loops;
    protected boolean debug;
    protected final String documentType;
    protected final String documentName;
    protected PluginPreparation optimizedForm;
    private boolean validating;

    public Plugin(String documentType, String documentName) {
        this.documentType = documentType;
        this.documentName = documentName;
        ++pluginsLoaded;
    }

    protected Plugin(String documentType, String documentName, boolean validating) {
        this(documentType, documentName);
        this.validating = validating;
    }

    public void init() {
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public LoopDescriptor[] getLoopDescriptors() {
        return this.loops;
    }

    public LoopDescriptor query(String segment, String currentLoopStack, int currentLevel, Set<String> resultFlags) {
        LoopDescriptor result = null;
        logger.debug("plugin query for segment {}", (Object)segment);
        if (this.loops == null) {
            return null;
        }
        if (this.optimizedForm == null) {
            throw new RuntimeException("Internal error: plugin not properly constructed");
        }
        List<LoopDescriptor> descriptorList = this.optimizedForm.getList(segment);
        if (descriptorList == null) {
            logger.debug("No descriptors found");
            return null;
        }
        logger.debug("Number of descriptors found: {}", (Object)descriptorList.size());
        for (LoopDescriptor descriptor : descriptorList) {
            boolean candidate = this.matchesWithoutRegardToFlagConditionals(descriptor, segment, currentLoopStack, currentLevel);
            if (!candidate) continue;
            Set<String> conditions = descriptor.getConditionFlags();
            boolean satisfied = true;
            for (String condition : conditions) {
                if (resultFlags != null && resultFlags.contains(condition)) continue;
                satisfied = false;
                break;
            }
            if (!satisfied) continue;
            result = descriptor;
            break;
        }
        if (result != null && result.getName() == null) {
            result = null;
        }
        return result;
    }

    private boolean matchesWithoutRegardToFlagConditionals(LoopDescriptor descriptor, String segment, String currentLoopStack, int currentLevel) {
        if (!descriptor.getFirstSegment().equals(segment)) {
            throw new RuntimeException("Internal error: optimized plugin structure invalid");
        }
        int levelContext = descriptor.getLevelContext();
        logger.debug("checking level context {}", (Object)levelContext);
        if (levelContext > -1) {
            return levelContext == currentLevel;
        }
        String candidateContext = descriptor.getLoopContext();
        if (currentLoopStack == null) {
            currentLoopStack = ANY_CONTEXT;
        }
        if (this.debug) {
            logger.debug("checking loop context {} with current loop stack {}", (Object)candidateContext, (Object)currentLoopStack);
        }
        if (ANY_CONTEXT.equals(candidateContext)) {
            return true;
        }
        if (candidateContext.startsWith(INITIAL_CONTEXT) && candidateContext.length() > 1 && currentLoopStack.startsWith(candidateContext)) {
            logger.debug("startsWith satisfied");
            return true;
        }
        return currentLoopStack.endsWith(candidateContext);
    }

    public static int getCount() {
        return pluginsLoaded;
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append("Plugin ").append(this.getClass().getName()).append("\n  ").append(this.getDocumentName()).append(" (").append(this.getDocumentType()).append(')');
        if (this.loops != null) {
            for (LoopDescriptor loop : this.loops) {
                result.append('\n').append(loop.toString());
            }
        }
        return result.toString();
    }

    public void prepare() {
        this.optimizedForm = new PluginPreparation(this.loops);
    }

    public boolean isValidating() {
        return this.validating;
    }

    public PluginControllerImpl createController(String standard, Tokenizer tokenizer) {
        return new PluginControllerImpl(standard, tokenizer);
    }

    protected LoopDescriptor[] concatenate(LoopDescriptor[] descriptorsA, LoopDescriptor[] descriptorsB) {
        LoopDescriptor[] result = new LoopDescriptor[descriptorsA.length + descriptorsB.length];
        int loopsIndex = 0;
        for (LoopDescriptor d : descriptorsA) {
            result[loopsIndex++] = d;
        }
        for (LoopDescriptor d : descriptorsB) {
            result[loopsIndex++] = d;
        }
        return result;
    }

    public String getDocumentVersion() {
        String result = null;
        String simpleName = this.getClass().getSimpleName();
        String[] split = simpleName.split("_");
        if (split.length == 4) {
            result = split[3];
        }
        return result;
    }

    public PluginDiff compare(Plugin pluginB) {
        PluginDiff result = new PluginDiff();
        if (pluginB == null) {
            return result.mismatch("second plugin is null");
        }
        if (!this.getDocumentType().equals(pluginB.getDocumentType())) {
            return result.mismatch("types differ");
        }
        if (!this.getDocumentName().equals(pluginB.getDocumentName())) {
            return result.mismatch("names differ");
        }
        LoopDescriptor[] loopsOfB = pluginB.loops;
        if (this.loops == null) {
            if (loopsOfB != null) {
                return result.mismatch("second plugin has non-null loops while this plugin does not");
            }
        } else {
            if (loopsOfB == null) {
                return result.mismatch("second plugin has null loops while this plugin does not");
            }
            if (this.loops.length != loopsOfB.length) {
                return result.mismatch("second plugin has a different number of loops than this plugin");
            }
        }
        result.setMatch(true);
        return result;
    }

    public static class PluginDiff {
        private boolean match;
        private String reason;

        public boolean isMatch() {
            return this.match;
        }

        public void setMatch(boolean match) {
            this.match = match;
        }

        public String getReason() {
            return this.isMatch() ? "matches" : this.reason;
        }

        public void setReason(String reason) {
            this.reason = reason;
        }

        public PluginDiff mismatch(String s) {
            this.setMatch(false);
            this.setReason(s);
            return this;
        }
    }
}

