/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader;

import com.berryworks.edireader.StandardReader;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class ReplyGenerator {
    protected StandardReader standardReader;
    protected String controlDateAndTimeOverride;
    protected DateFormat yymmdd;
    protected DateFormat yyyymmdd;
    protected DateFormat hhmm;

    public abstract void generateAcknowledgementWrapup() throws IOException;

    public abstract void generateTransactionAcknowledgment(String var1, String var2) throws IOException;

    public abstract void generateAcknowledgmentHeader(String var1, String var2, String var3, int var4, String var5, String var6, String var7) throws IOException;

    public abstract void generateAcknowledgmentHeader(String var1, String var2, String var3, String var4, String var5, String var6, String var7) throws IOException;

    public abstract void generateGroupAcknowledgmentTrailer(int var1) throws IOException;

    public abstract void generateNegativeACK() throws IOException;

    public void setControlDateAndTime(String overrideValue) {
        this.controlDateAndTimeOverride = overrideValue;
    }

    public String controlDateAndTime(int dateLength) {
        return this.controlDateAndTime(dateLength, this.standardReader.getDelimiter());
    }

    public String controlDateAndTime(int dateLength, char delimiter) {
        if (this.controlDateAndTimeOverride != null) {
            return this.controlDateAndTimeOverride;
        }
        if (this.yymmdd == null) {
            this.yymmdd = new SimpleDateFormat("yyMMdd");
        }
        if (this.yyyymmdd == null) {
            this.yyyymmdd = new SimpleDateFormat("yyyyMMdd");
        }
        if (this.hhmm == null) {
            this.hhmm = new SimpleDateFormat("HHmm");
        }
        Date now = new Date();
        DateFormat sixOrEight = dateLength == 6 ? this.yymmdd : this.yyyymmdd;
        return sixOrEight.format(now) + delimiter + this.hhmm.format(now);
    }
}

