/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader;

import com.berryworks.edireader.EDIAttributes;
import com.berryworks.edireader.EDIReader;
import com.berryworks.edireader.EDISyntaxException;
import com.berryworks.edireader.PluginController;
import com.berryworks.edireader.ReplyGenerator;
import com.berryworks.edireader.error.EDISyntaxExceptionHandler;
import com.berryworks.edireader.error.GroupControlNumberException;
import com.berryworks.edireader.error.GroupCountException;
import com.berryworks.edireader.error.InterchangeControlNumberException;
import com.berryworks.edireader.error.RecoverableSyntaxException;
import com.berryworks.edireader.error.SegmentCountException;
import com.berryworks.edireader.error.TransactionControlNumberException;
import com.berryworks.edireader.error.TransactionCountException;
import com.berryworks.edireader.plugin.PluginControllerFactory;
import com.berryworks.edireader.plugin.PluginControllerFactoryInterface;
import com.berryworks.edireader.tokenizer.Token;
import com.berryworks.edireader.util.FixedLength;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class StandardReader
extends EDIReader {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getSimpleName());
    private String interchangeControlNumber;
    private String groupControlNumber;
    private int groupCount;
    private int documentCount;
    private ReplyGenerator ackGenerator;
    private ReplyGenerator alternateAckGenerator;
    private RecoverableSyntaxException syntaxException;
    private PluginControllerFactoryInterface pluginControllerFactory;
    protected PluginController segmentPluginController;

    protected abstract Token recognizeBeginning() throws IOException, SAXException;

    protected abstract Token parseInterchange(Token var1) throws SAXException, IOException;

    @Override
    public void parse(InputSource source) throws SAXException, IOException {
        if (source == null) {
            throw new IOException("parse called with null InputSource");
        }
        if (this.getContentHandler() == null) {
            throw new IOException("parse called with null ContentHandler");
        }
        if (!this.isExternalXmlDocumentStart()) {
            this.startXMLDocument();
        }
        this.parseSetup(source);
        this.getTokenizer().setDelimiter(this.getDelimiter());
        this.getTokenizer().setSubDelimiter(this.getSubDelimiter());
        this.getTokenizer().setRelease(this.getRelease());
        this.getTokenizer().setRepetitionSeparator(this.getRepetitionSeparator());
        this.getTokenizer().setTerminator(this.getTerminator());
        try {
            this.parseInterchange(this.recognizeBeginning());
        }
        catch (EDISyntaxException e) {
            if (this.ackGenerator != null) {
                this.ackGenerator.generateNegativeACK();
            }
            if (this.alternateAckGenerator != null) {
                this.alternateAckGenerator.generateNegativeACK();
            }
            throw e;
        }
        if (!this.isExternalXmlDocumentStart()) {
            this.endXMLDocument();
        }
    }

    protected void parseSegmentElement(Token t) throws SAXException {
        String elementId = t.getElementId();
        switch (t.getType()) {
            case SIMPLE: {
                if (t.getValueLength() == 0 || !t.containsNonSpace() && !this.isKeepSpacesOnlyElements()) {
                    return;
                }
                EDIAttributes attributes = this.getDocumentAttributes();
                attributes.clear();
                attributes.addCDATA(this.getXMLTags().getIdAttribute(), elementId);
                this.startElement(this.getXMLTags().getElementTag(), attributes);
                this.getContentHandler().characters(t.getValueChars(), 0, t.getValueLength());
                this.endElement(this.getXMLTags().getElementTag());
                if (this.segmentPluginController == null) break;
                this.segmentPluginController.noteElement(this.getContentHandler(), elementId, t.getValueChars(), 0, t.getValueLength());
                break;
            }
            case SUB_ELEMENT: {
                EDIAttributes attributes = this.getDocumentAttributes();
                if (t.isFirst()) {
                    attributes.clear();
                    attributes.addCDATA(this.getXMLTags().getIdAttribute(), elementId);
                    attributes.addCDATA(this.getXMLTags().getCompositeIndicator(), "yes");
                    this.startElement(this.getXMLTags().getElementTag(), attributes);
                }
                attributes.clear();
                attributes.addAttribute("", this.getXMLTags().getSubElementSequence(), this.getXMLTags().getSubElementSequence(), "CDATA", String.valueOf(1 + t.getSubIndex()));
                this.startElement(this.getXMLTags().getSubElementTag(), attributes);
                this.getContentHandler().characters(t.getValueChars(), 0, t.getValueLength());
                this.endElement(this.getXMLTags().getSubElementTag());
                if (!t.isLast()) break;
                this.endElement(this.getXMLTags().getElementTag());
                break;
            }
            case SUB_EMPTY: {
                if (t.isFirst()) {
                    EDIAttributes attributes = this.getDocumentAttributes();
                    attributes.clear();
                    attributes.addCDATA(this.getXMLTags().getIdAttribute(), elementId);
                    attributes.addCDATA(this.getXMLTags().getCompositeIndicator(), "yes");
                    this.startElement(this.getXMLTags().getElementTag(), attributes);
                }
                if (!t.isLast()) break;
                this.endElement(this.getXMLTags().getElementTag());
            }
        }
    }

    public void setControlDateAndTime(String overrideValue) {
        ReplyGenerator generator = this.getAckGenerator();
        if (generator != null) {
            generator.setControlDateAndTime(overrideValue);
        }
        if ((generator = this.getAlternateAckGenerator()) != null) {
            generator.setControlDateAndTime(overrideValue);
        }
    }

    protected boolean recover(RecoverableSyntaxException e) {
        boolean result = false;
        EDISyntaxExceptionHandler handler = this.getSyntaxExceptionHandler();
        if (handler == null) {
            logger.warn(e.getMessage());
        } else {
            result = handler.process(e);
        }
        return result;
    }

    public int getGroupCount() {
        return this.groupCount;
    }

    public void setGroupCount(int groupCount) {
        this.groupCount = groupCount;
    }

    public String getInterchangeControlNumber() {
        return this.interchangeControlNumber;
    }

    public void setInterchangeControlNumber(String interchangeControlNumber) {
        this.interchangeControlNumber = interchangeControlNumber;
    }

    public String getGroupControlNumber() {
        return this.groupControlNumber;
    }

    public void setGroupControlNumber(String groupControlNumber) {
        this.groupControlNumber = groupControlNumber;
    }

    public int getDocumentCount() {
        return this.documentCount;
    }

    public void setDocumentCount(int documentCount) {
        this.documentCount = documentCount;
    }

    public RecoverableSyntaxException getSyntaxException() {
        return this.syntaxException;
    }

    public void setSyntaxException(RecoverableSyntaxException syntaxException) {
        this.syntaxException = syntaxException;
    }

    protected String parseStringFromNextElement() throws IOException, EDISyntaxException {
        String obj;
        List<String> v = this.getTokenizer().nextCompositeElement();
        if (FixedLength.isPresent(v) && (obj = v.get(0)) != null) {
            return obj;
        }
        EDISyntaxException se = new EDISyntaxException("Mandatory element missing", this.getTokenizer());
        logger.warn(se.getMessage());
        throw se;
    }

    protected void checkGroupCount(int groupCount, int n, String errorMessage) throws GroupCountException {
        if (groupCount != n) {
            GroupCountException se = new GroupCountException(errorMessage, groupCount, n, this.getTokenizer());
            this.setSyntaxException(se);
            if (!this.recover(se)) {
                throw se;
            }
        }
    }

    protected void checkTransactionCount(int segCount, int n, String errorMessage) throws TransactionCountException {
        if (segCount != n) {
            TransactionCountException se = new TransactionCountException(errorMessage, segCount, n, this.getTokenizer());
            this.setSyntaxException(se);
            if (!this.recover(se)) {
                throw se;
            }
        }
    }

    protected void checkSegmentCount(int segCount, int n, String errorMessage) throws SegmentCountException {
        if (segCount != n) {
            SegmentCountException se = new SegmentCountException(errorMessage, segCount, n, this.getTokenizer());
            this.setSyntaxException(se);
            if (!this.recover(se)) {
                throw se;
            }
        }
    }

    protected void checkInterchangeControlNumber(String expected, String actual, String errorMessage) throws InterchangeControlNumberException {
        if (actual == null) {
            actual = "(omitted)";
        }
        if (!actual.equals(expected)) {
            InterchangeControlNumberException se = new InterchangeControlNumberException(errorMessage, expected, actual, this.getTokenizer());
            this.setSyntaxException(se);
            if (!this.recover(se)) {
                throw se;
            }
        }
    }

    protected void checkGroupControlNumber(String control, String s, String errorMessage) throws GroupControlNumberException {
        if (!s.equals(control)) {
            GroupControlNumberException se = new GroupControlNumberException(errorMessage, control, s, this.getTokenizer());
            this.setSyntaxException(se);
            if (!this.recover(se)) {
                throw se;
            }
        }
    }

    protected void checkTransactionControlNumber(String expected, String actual, String errorMessage) throws TransactionControlNumberException {
        if (actual == null) {
            actual = "(omitted)";
        }
        if (!actual.equals(expected)) {
            TransactionControlNumberException se = new TransactionControlNumberException(errorMessage, expected, actual, this.getTokenizer());
            this.setSyntaxException(se);
            if (!this.recover(se)) {
                throw se;
            }
        }
    }

    public ReplyGenerator getAckGenerator() {
        return this.ackGenerator;
    }

    public void setAckGenerator(ReplyGenerator generator) {
        this.ackGenerator = generator;
    }

    public ReplyGenerator getAlternateAckGenerator() {
        return this.alternateAckGenerator;
    }

    public void setAlternateAckGenerator(ReplyGenerator generator) {
        this.alternateAckGenerator = generator;
    }

    public PluginControllerFactoryInterface getPluginControllerFactory() {
        if (this.pluginControllerFactory == null) {
            this.pluginControllerFactory = new PluginControllerFactory();
        }
        return this.pluginControllerFactory;
    }

    @Override
    public void setPluginControllerFactory(PluginControllerFactoryInterface pluginControllerFactory) {
        this.pluginControllerFactory = pluginControllerFactory;
    }

    protected void parseSegment(PluginController pluginController, String segmentType) throws SAXException, IOException {
        Token t;
        this.segmentPluginController = pluginController;
        if (pluginController.transition(segmentType)) {
            int toClose;
            logger.debug("closing {} loops", (Object)toClose);
            for (toClose = pluginController.closedCount(); toClose > 0; --toClose) {
                this.endElement(this.getXMLTags().getLoopTag());
            }
            String s = pluginController.getLoopEntered();
            if (!pluginController.isResumed()) {
                this.getDocumentAttributes().clear();
                this.getDocumentAttributes().addCDATA(this.getXMLTags().getIdAttribute(), s);
                this.startElement(this.getXMLTags().getLoopTag(), this.getDocumentAttributes());
            }
        }
        this.getDocumentAttributes().clear();
        this.getDocumentAttributes().addCDATA(this.getXMLTags().getIdAttribute(), segmentType);
        this.startElement(this.getXMLTags().getSegTag(), this.getDocumentAttributes());
        if (this.segmentPluginController != null) {
            this.segmentPluginController.noteBeginningOfSegment(this.getContentHandler(), segmentType);
        }
        while ((t = this.getTokenizer().nextToken()).getType() != Token.TokenType.SEGMENT_END) {
            switch (t.getType()) {
                case SIMPLE: 
                case SUB_ELEMENT: 
                case SUB_EMPTY: 
                case EMPTY: {
                    break;
                }
                case END_OF_DATA: {
                    EDISyntaxException se = new EDISyntaxException("Unexpected end of data", this.getTokenizer());
                    logger.warn(se.getMessage());
                    throw se;
                }
                default: {
                    EDISyntaxException se = new EDISyntaxException("Malformed EDI segment", this.getTokenizer());
                    logger.warn(se.getMessage());
                    throw se;
                }
            }
            this.parseSegmentElement(t);
        }
        if (this.segmentPluginController != null) {
            this.segmentPluginController.noteEndOfSegment(this.getContentHandler(), segmentType);
        }
        this.endElement(this.getXMLTags().getSegTag());
    }

    protected void startInterchange(EDIAttributes attributes) throws SAXException {
        this.startElement(this.getXMLTags().getInterchangeTag(), attributes);
    }

    protected void endInterchange() throws SAXException {
        this.endElement(this.getXMLTags().getInterchangeTag());
    }

    protected void startMessage(EDIAttributes attributes) throws SAXException {
        this.startElement(this.getXMLTags().getDocumentTag(), attributes);
    }

    protected String getSubElement(List<String> compositeList, int i) {
        String result = "";
        try {
            result = compositeList.get(i);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return result;
    }

    protected void generatedSenderAndReceiver(String fromId, String fromQual, String fromExtra, String toId, String toQual, String toExtra) throws SAXException {
        this.getInterchangeAttributes().clear();
        this.startElement(this.getXMLTags().getSenderTag(), this.getInterchangeAttributes());
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getIdAttribute(), fromId);
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getQualifierAttribute(), fromQual);
        if (FixedLength.isPresent(fromExtra)) {
            this.getInterchangeAttributes().addCDATA("Extra", fromExtra);
        }
        this.startSenderAddress(this.getInterchangeAttributes());
        this.endElement(this.getXMLTags().getAddressTag());
        this.endElement(this.getXMLTags().getSenderTag());
        this.getInterchangeAttributes().clear();
        this.startElement(this.getXMLTags().getReceiverTag(), this.getInterchangeAttributes());
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getIdAttribute(), toId);
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getQualifierAttribute(), toQual);
        if (FixedLength.isPresent(toExtra)) {
            this.getInterchangeAttributes().addCDATA(this.getXMLTags().getAddressExtraAttribute(), toExtra);
        }
        this.startReceiverAddress(this.getInterchangeAttributes());
        this.endElement(this.getXMLTags().getAddressTag());
        this.endElement(this.getXMLTags().getReceiverTag());
    }

    protected void startSenderAddress(EDIAttributes attributes) throws SAXException {
        this.startElement(this.getXMLTags().getAddressTag(), attributes);
    }

    protected void startReceiverAddress(EDIAttributes attributes) throws SAXException {
        this.startElement(this.getXMLTags().getAddressTag(), attributes);
    }
}

