/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.benchmark;

import com.berryworks.edireader.EDIReader;
import com.berryworks.edireader.EDIReaderFactory;
import com.berryworks.edireader.benchmark.BenchmarkUnitOfWork;
import com.berryworks.edireader.benchmark.EDITestData;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Writer;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class AnsiUnitOfWork
extends BenchmarkUnitOfWork {
    @Override
    public void run() {
        if (this.getSessionCounter() == null) {
            throw new RuntimeException("SessionCounter net set");
        }
        PipedWriter pipedWriter = new PipedWriter();
        try {
            PipedReader pipedReader = new PipedReader(pipedWriter);
            this.generateContent(pipedWriter);
            InputSource inputSource = new InputSource(pipedReader);
            EDIReader reader = EDIReaderFactory.createEDIReader(inputSource);
            reader.setContentHandler(new DefaultHandler());
            reader.parse(inputSource);
            int charCount = reader.getTokenizer().getCharCount();
            this.getCharCounter().add(charCount);
        }
        catch (Exception e) {
            throw new RuntimeException("caught exception", e);
        }
        this.getSessionCounter().stop();
    }

    private void generateContent(Writer writer) {
        EDITestData generator = new EDITestData();
        generator.setWriter(writer);
        generator.setInterchangeKCs(this.getInterchangeKCs());
        new Thread(generator).start();
    }
}

