/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.benchmark;

import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import org.xml.sax.InputSource;

public class EDITestData
implements Runnable {
    private static final String ISA_FRAGMENT = "ISA~00~          ~00~          ~ZZ~04000          ~ZZ~58401          ~040714~1003~U~00204~000038449~1~P~<$";
    private static final String GS_FRAGMENT = "GS~AG~04000~58401~040714~1003~38327~X~002040CHRY$";
    private static final String A824_FRAGMENT = "ST~824~000042460$BGN~11~07141005162~040714~1003$N1~SU~~92~58401O$N1~SF~~92~58401O$N1~ST~~92~05304$N1~MA~~92~05304$OTI~IA~SI~AC32804~~~~~~~856$REF~BM~AC32804$REF~PK~00032804$REF~PM~52069902AA$DTM~009~040714~1003~ED$";
    private static final String B824_FRAGMENT = "DTM~011~040714$OTI~IA~SI~AC32804~~~~~~~856$REF~BM~AC32804$REF~PK~00032804$REF~PM~0CP00015$DTM~009~040714~1003~ED$DTM~011~040714$OTI~IA~SI~AC32804~~~~~~~856$REF~BM~AC32804$REF~PK~00032804$REF~PM~0CD03536$DTM~009~040714~1003~ED$DTM~011~040714$OTI~IA~SI~AC32804~~~~~~~856$REF~BM~AC32804$REF~PK~00032804$REF~PM~0CP00016$DTM~009~040714~1003~ED$DTM~011~040714$SE~";
    private static final String FILLER_FRAGMENT = "DTM~009~040714~1003~ED$";
    private static final String DOCUMENT_CONTROL_NUMBER = "~000042460$";
    private static final String GROUP_CONTROL_NUMBER = "~38327$";
    private static final String INTERCHANGE_CONTROL_NUMBER = "~000038449$";
    private Writer writer;
    private int fillerSegments;

    public static InputSource getAnsiInputSource() {
        return new InputSource(new StringReader(EDITestData.getAnsiInterchange()));
    }

    private static String getAnsiISA() {
        return ISA_FRAGMENT;
    }

    private static String getAnsiGS() {
        return GS_FRAGMENT;
    }

    private static String getAnsiGE(int count) {
        return "GE~" + count + GROUP_CONTROL_NUMBER;
    }

    private static String getAnsiIEA(int count) {
        return "IEA~" + count + INTERCHANGE_CONTROL_NUMBER;
    }

    private static String getAnsi824PartA() {
        return A824_FRAGMENT;
    }

    private static String getAnsi824Filler() {
        return FILLER_FRAGMENT;
    }

    private static String getAnsi824PartB(int fillerSegments) {
        int segmentCount = 31 + fillerSegments;
        return B824_FRAGMENT + segmentCount + DOCUMENT_CONTROL_NUMBER;
    }

    public static String getAnsiInterchange() {
        return EDITestData.getAnsiInterchange(1);
    }

    public static String getAnsiInterchange(int numberOfDocuments) {
        return EDITestData.getAnsiInterchange(1, numberOfDocuments);
    }

    public static String getAnsiInterchange(int numberOfGroups, int numberOfDocuments) {
        StringBuilder result = new StringBuilder(EDITestData.getAnsiISA());
        for (int i = 0; i < numberOfGroups; ++i) {
            result.append(EDITestData.getAnsiGS());
            for (int j = 0; j < numberOfDocuments; ++j) {
                result.append(EDITestData.getAnsi824PartA()).append(EDITestData.getAnsi824PartB(0));
            }
            result.append(EDITestData.getAnsiGE(numberOfDocuments));
        }
        result.append(EDITestData.getAnsiIEA(numberOfGroups));
        return result.toString();
    }

    public static InputSource getEdifactInputSource() {
        return new InputSource(new StringReader(EDITestData.getEdifactInterchange()));
    }

    public static InputSource getEdifactInputSource(String type) {
        return new InputSource(new StringReader(EDITestData.getEdifactInterchange(type, "APR")));
    }

    public static String getEdifactInterchange() {
        return EDITestData.getEdifactInterchange(1);
    }

    public static String getEdifactInterchange(int numberOfMessages) {
        return EDITestData.getEdifactInterchange(numberOfMessages, "DCQCKI", "APR");
    }

    public static String getEdifactInterchange(String type) {
        return EDITestData.getEdifactInterchange(type, "APR");
    }

    public static String getEdifactInterchange(String type, String appRef) {
        return EDITestData.getEdifactInterchange(1, type, appRef);
    }

    public static String getEdifactInterchange(int numberOfMessage, String type, String appRef) {
        return EDITestData.getEdifactInterchange(numberOfMessage, type, "CONVTST2", appRef);
    }

    public static String getEdifactInterchange(String type, String recipientRef, String appRef) {
        return EDITestData.getEdifactInterchange(1, type, recipientRef, appRef);
    }

    public static String getEdifactInterchange(int numberOfMessages, String type, String recipientRef, String appRef) {
        StringBuilder result = new StringBuilder("UNB+IATA:1+REUAIR08DLH:PIMA+REUAGT82AGENT/LHR01:PIMA+941027:1520+841F60UNZ+" + recipientRef + "+" + appRef + "+L+1'");
        for (int n = 1; n <= numberOfMessages; ++n) {
            result.append("UNH+").append(n).append("+").append(type).append(":90:1:IA+841F60'").append("LOR+SR:GVA'FDQ+DL+573+890701+ATL+MIA++SR+120+8907011300+8907011655+ZRH+ATL'PPD+MEIER+F:Y++BARBARAMRS+MILLER:JOHN'PRD+Y'PSD+N'PBD+2:22'").append("UNT+8+").append(n).append("'");
        }
        result.append("UNZ+").append(numberOfMessages).append("+841F60UNZ'");
        return result.toString();
    }

    @Override
    public void run() {
        try {
            this.writer.write(EDITestData.getAnsiISA());
            this.writer.write(EDITestData.getAnsiGS());
            this.writer.write(EDITestData.getAnsi824PartA());
            for (int i = 0; i < this.fillerSegments; ++i) {
                this.writer.write(EDITestData.getAnsi824Filler());
            }
            this.writer.write(EDITestData.getAnsi824PartB(this.fillerSegments));
            this.writer.write(EDITestData.getAnsiGE(1));
            this.writer.write(EDITestData.getAnsiIEA(1));
            this.writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception generating data: " + e);
        }
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    protected void setFillerSegments(int count) {
        this.fillerSegments = count;
    }

    public void setInterchangeKCs(int kcs) {
        int n = ISA_FRAGMENT.length() + GS_FRAGMENT.length() + A824_FRAGMENT.length();
        n += B824_FRAGMENT.length() + 6 + DOCUMENT_CONTROL_NUMBER.length();
        n += 4 + GROUP_CONTROL_NUMBER.length();
        int needed = kcs * 1024 - (n += 5 + INTERCHANGE_CONTROL_NUMBER.length());
        int f = needed / FILLER_FRAGMENT.length();
        this.setFillerSegments(Math.max(f, 0));
    }
}

