/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.demo;

import com.berryworks.edireader.demo.EDItoXML;
import com.berryworks.edireader.filter.EdiReaderFilter;
import com.berryworks.edireader.plugin.AbstractPluginControllerFactory;
import com.berryworks.edireader.splitter.ClosingDetails;
import com.berryworks.edireader.splitter.HandlerFactory;
import com.berryworks.edireader.splitter.SplittingHandler;
import com.berryworks.edireader.util.CommandLine;
import com.berryworks.edireader.util.dom.DomBuildingSaxHandler;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EDISplitter {
    private static int count;
    private final InputSource inputSource;
    private HandlerFactory handlerFactory;
    private int transactionCountLimit;
    private int segmentCountLimit;
    private AbstractPluginControllerFactory pluginControllerFactory;
    private EdiReaderFilter filter;

    public EDISplitter(Reader inputReader, String outputFileNamePattern) {
        this.inputSource = new InputSource(inputReader);
        this.setHandlerFactory(new FileSequenceHandlerFactory(outputFileNamePattern));
    }

    public void run() throws IOException, SAXException {
        SplittingHandler splittingHandler = new SplittingHandler(this.handlerFactory);
        splittingHandler.setFilter(this.filter);
        splittingHandler.setPluginControllerFactory(this.pluginControllerFactory);
        splittingHandler.setTransactionCountLimit(this.transactionCountLimit);
        splittingHandler.setSegmentCountLimit(this.segmentCountLimit);
        splittingHandler.split(this.inputSource);
    }

    public AbstractPluginControllerFactory getPluginControllerFactory() {
        return this.pluginControllerFactory;
    }

    public void setPluginControllerFactory(AbstractPluginControllerFactory pluginControllerFactory) {
        this.pluginControllerFactory = pluginControllerFactory;
    }

    public void setFilter(EdiReaderFilter filter) {
        this.filter = filter;
    }

    public void setHandlerFactory(HandlerFactory handlerFactory) {
        this.handlerFactory = handlerFactory;
    }

    public static void main(String[] args) {
        CommandLine commandLine = new CommandLine(args);
        String inputFileName = commandLine.getPosition(0);
        String outputFileNamePattern = commandLine.getOption("o");
        if (outputFileNamePattern == null) {
            EDISplitter.badArgs();
        }
        Reader inputReader = EDItoXML.establishInput(inputFileName);
        EDISplitter ediSplitter = new EDISplitter(inputReader, outputFileNamePattern);
        try {
            ediSplitter.run();
        }
        catch (IOException | SAXException e) {
            System.out.print(e);
            throw new RuntimeException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new RuntimeException(e.getMessage());
        }
        String s = System.getProperty("line.separator");
        System.out.print(s + "EDI input parsed into " + count + " XML output files" + s);
    }

    private static void badArgs() {
        System.err.println("Usage: EDISplitter [inputFile] [-o outputFilenamePattern]");
        throw new RuntimeException("Missing or invalid command line arguments");
    }

    public static int getCount() {
        return count;
    }

    public static void resetCount() {
        count = 0;
    }

    public void setTransactionCountLimit(int limit) {
        this.transactionCountLimit = limit;
    }

    public void setSegmentCountLimit(int limit) {
        this.segmentCountLimit = limit;
    }

    protected static class FileSequenceHandlerFactory
    implements HandlerFactory {
        private String filenameSuffix;
        private String filenamePrefix;
        private int sequenceNumberLength;
        private DomBuildingSaxHandler saxHandler;

        public FileSequenceHandlerFactory(String fileNamePattern) {
            this.establishPattern(fileNamePattern);
        }

        @Override
        public ContentHandler createDocument() throws Exception {
            count++;
            this.saxHandler = new DomBuildingSaxHandler();
            return this.saxHandler;
        }

        @Override
        public void closeDocument(ClosingDetails closingDetails) throws IOException {
            String xmlFilename = this.generateName();
            DOMSource source = new DOMSource(this.saxHandler.getDocument());
            try (FileWriter writer = new FileWriter(xmlFilename);){
                TransformerFactory.newInstance().newTransformer().transform(source, new StreamResult(writer));
            }
            catch (TransformerException e) {
                throw new IOException("Unable to generate XML from DOM");
            }
        }

        @Override
        public void markEndOfStream() {
        }

        private void establishPattern(String fileNamePattern) {
            String[] splitResult = fileNamePattern.split("0+", 2);
            if (splitResult.length < 2) {
                EDISplitter.badArgs();
            }
            this.filenamePrefix = splitResult[0];
            this.filenameSuffix = splitResult[1];
            this.sequenceNumberLength = fileNamePattern.length() - this.filenamePrefix.length() - this.filenameSuffix.length();
        }

        private String generateName() {
            String sequenceDigits = "" + (100000 + count);
            sequenceDigits = sequenceDigits.substring(sequenceDigits.length() - this.sequenceNumberLength);
            return this.filenamePrefix + sequenceDigits + this.filenameSuffix;
        }
    }
}

