/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.demo;

import com.berryworks.edireader.EDIReader;
import com.berryworks.edireader.error.EDISyntaxExceptionHandler;
import com.berryworks.edireader.error.RecoverableSyntaxException;
import com.berryworks.edireader.util.CommandLine;
import com.berryworks.edireader.util.XmlFormatter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.InputSource;

public class EDItoXML {
    public static final String NEW_LINE = System.getProperty("line.separator");
    private Writer generatedOutput;
    private Writer acknowledgmentWriter;
    private Reader inputReader;
    private boolean namespaceEnabled;
    private boolean recover;

    public static void main(String[] args) {
        EDItoXML theObject = new EDItoXML();
        if (!EDItoXML.configure(args, theObject)) {
            return;
        }
        theObject.run();
    }

    public void run() {
        try {
            EDIReader ediReader = this.createEDIReader();
            if (this.namespaceEnabled) {
                ediReader.setNamespaceEnabled(true);
            }
            if (this.recover) {
                ediReader.setSyntaxExceptionHandler(new IgnoreSyntaxExceptions());
            }
            if (this.acknowledgmentWriter != null) {
                ediReader.setAcknowledgment(this.acknowledgmentWriter);
            }
            SAXSource source = new SAXSource(ediReader, new InputSource(this.inputReader));
            StreamResult result = new StreamResult(this.generatedOutput);
            TransformerFactory.newInstance().newTransformer().transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            System.err.println("\nUnable to create Transformer: " + e);
        }
        catch (TransformerException e) {
            System.err.println("\nFailure to transform: " + e);
            System.err.println(e.getMessage());
        }
        try {
            this.inputReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.generatedOutput.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected EDIReader createEDIReader() {
        return new EDIReader();
    }

    static boolean configure(String[] args, EDItoXML theObject) {
        CommandLine commandLine = new CommandLine(args){

            @Override
            public String usage() {
                String text = NEW_LINE + "EDItoXML [ediInputFile] [-o xmlOutputFile] [-a acknowledgmentFile] [-n true|false] [-r true|false] [-i true|false]";
                text = text + NEW_LINE + "options:";
                text = text + NEW_LINE + "   -n   XML includes namespace declaration. Defaults to false.";
                text = text + NEW_LINE + "   -r   Recover and continue parsing after an error is detected in EDI input. Defaults to false.";
                text = text + NEW_LINE + "   -i   Indent XML output for readability. Defaults to false.";
                return text;
            }
        };
        if (!commandLine.isValid()) {
            return false;
        }
        String inputFileName = commandLine.getPosition(0);
        String outputFileName = commandLine.getOption("o");
        String acknowledgmentFileName = commandLine.getOption("a");
        boolean namespaceEnabled = "true".equals(commandLine.getOption("n"));
        boolean recover = "true".equals(commandLine.getOption("r"));
        boolean indent = "true".equals(commandLine.getOption("i"));
        Reader inputReader = EDItoXML.establishInput(inputFileName);
        Writer generatedOutput = EDItoXML.establishOutput(outputFileName);
        theObject.setInputReader(inputReader);
        theObject.setXmlOutputWriter(generatedOutput);
        theObject.setNamespaceEnabled(namespaceEnabled);
        theObject.setRecover(recover);
        theObject.setIndent(indent);
        if (acknowledgmentFileName != null) {
            theObject.setAcknowledgmentWriter(EDItoXML.establishOutput(acknowledgmentFileName));
        }
        return true;
    }

    static Writer establishOutput(String outputFileName) {
        OutputStreamWriter generatedOutput;
        if (outputFileName == null) {
            generatedOutput = new OutputStreamWriter(System.out);
        } else {
            try {
                generatedOutput = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFileName), StandardCharsets.ISO_8859_1);
                System.out.println("Output file " + outputFileName + " opened");
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                throw new RuntimeException(e.getMessage());
            }
        }
        return generatedOutput;
    }

    public static Reader establishInput(String inputFileName) {
        InputStreamReader inputReader;
        if (inputFileName == null) {
            inputReader = new InputStreamReader(System.in);
        } else {
            try {
                inputReader = new InputStreamReader((InputStream)new FileInputStream(inputFileName), StandardCharsets.ISO_8859_1);
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                throw new RuntimeException(e.getMessage());
            }
        }
        return inputReader;
    }

    public void setNamespaceEnabled(boolean namespaceEnabled) {
        this.namespaceEnabled = namespaceEnabled;
    }

    public void setRecover(boolean recover) {
        this.recover = recover;
    }

    public void setIndent(boolean indent) {
        if (indent && !(this.generatedOutput instanceof XmlFormatter)) {
            this.generatedOutput = new XmlFormatter(this.generatedOutput);
        }
    }

    public void setInputReader(Reader inputReader) {
        this.inputReader = inputReader;
    }

    public void setXmlOutputWriter(Writer xmlOutputWriter) {
        this.generatedOutput = xmlOutputWriter;
    }

    public void setAcknowledgmentWriter(Writer acknowledgmentWriter) {
        this.acknowledgmentWriter = acknowledgmentWriter;
    }

    public static class IgnoreSyntaxExceptions
    implements EDISyntaxExceptionHandler {
        @Override
        public boolean process(RecoverableSyntaxException syntaxException) {
            System.out.println("Syntax Exception. class: " + syntaxException.getClass().getName() + "  message:" + syntaxException.getMessage());
            return true;
        }
    }
}

