/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.demo;

import com.berryworks.edireader.EDIReader;
import com.berryworks.edireader.EDIReaderFactory;
import com.berryworks.edireader.EDISyntaxException;
import com.berryworks.edireader.demo.EDItoXML;
import com.berryworks.edireader.error.EDISyntaxExceptionHandler;
import com.berryworks.edireader.error.RecoverableSyntaxException;
import com.berryworks.edireader.util.CommandLine;
import com.berryworks.edireader.util.XmlFormatter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class EDItoXML_Variations {
    private final InputSource inputSource;
    private Writer generatedOutput;
    private final Reader inputReader;
    private boolean namespaceEnabled;
    private boolean recover;

    public EDItoXML_Variations(Reader inputReader, Writer outputWriter) {
        this.inputReader = inputReader;
        this.inputSource = new InputSource(inputReader);
        this.generatedOutput = outputWriter;
    }

    public void run() {
        try {
            EDIReader ediReader = new EDIReader();
            if (this.namespaceEnabled) {
                ediReader.setNamespaceEnabled(this.namespaceEnabled);
            }
            if (this.recover) {
                ediReader.setSyntaxExceptionHandler(new IgnoreSyntaxExceptions());
            }
            SAXSource source = new SAXSource(ediReader, this.inputSource);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StreamResult result = new StreamResult(this.generatedOutput);
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            System.err.println("\nUnable to create Transformer: " + e);
        }
        catch (TransformerException e) {
            System.err.println("\nFailure to transform: " + e);
            System.err.println(e.getMessage());
        }
        try {
            this.inputReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.generatedOutput.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void run_alternate1() {
        try {
            EDIReader ediReader = EDIReaderFactory.createEDIReader(this.inputSource);
            if (this.namespaceEnabled) {
                ediReader.setNamespaceEnabled(this.namespaceEnabled);
            }
            if (this.recover) {
                ediReader.setSyntaxExceptionHandler(new IgnoreSyntaxExceptions());
            }
            SAXSource source = new SAXSource(ediReader, this.inputSource);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StreamResult result = new StreamResult(this.generatedOutput);
            transformer.transform(source, result);
        }
        catch (EDISyntaxException e) {
            System.err.println("\nSyntax error while parsing EDI: " + e);
        }
        catch (IOException e) {
            System.err.println("\nException attempting to read EDI data: " + e);
        }
        catch (TransformerConfigurationException e) {
            System.err.println("\nUnable to create Transformer: " + e);
        }
        catch (TransformerException e) {
            System.err.println("\nFailure to transform: " + e);
            System.err.println(e.getMessage());
        }
    }

    public void run_alternate2() {
        try {
            System.setProperty("javax.xml.parsers.SAXParserFactory", "com.berryworks.edireader.EDIParserFactory");
            SAXParserFactory sFactory = SAXParserFactory.newInstance();
            SAXParser sParser = sFactory.newSAXParser();
            XMLReader ediReader = sParser.getXMLReader();
            if (this.namespaceEnabled) {
                ((EDIReader)ediReader).setNamespaceEnabled(this.namespaceEnabled);
            }
            if (this.recover) {
                ((EDIReader)ediReader).setSyntaxExceptionHandler(new IgnoreSyntaxExceptions());
            }
            SAXSource source = new SAXSource(ediReader, this.inputSource);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StreamResult result = new StreamResult(this.generatedOutput);
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException | SAXException e) {
            System.err.println("\nUnable to create EDIReader: " + e);
        }
        catch (TransformerConfigurationException e) {
            System.err.println("\nUnable to create Transformer: " + e);
        }
        catch (TransformerException e) {
            System.err.println("\nFailure to transform: " + e);
            System.err.println(e.getMessage());
        }
    }

    public static void main(String[] args) {
        CommandLine commandLine = new CommandLine(args){

            @Override
            public String usage() {
                return "EDItoXML [inputfile] [-o outputfile] [-n true|false] [-r true|false] [-i true|false]";
            }
        };
        String inputFileName = commandLine.getPosition(0);
        String outputFileName = commandLine.getOption("o");
        boolean namespaceEnabled = "true".equals(commandLine.getOption("n"));
        boolean recover = "true".equals(commandLine.getOption("r"));
        boolean indent = "true".equals(commandLine.getOption("i"));
        Reader inputReader = EDItoXML.establishInput(inputFileName);
        Writer generatedOutput = EDItoXML.establishOutput(outputFileName);
        EDItoXML_Variations theObject = new EDItoXML_Variations(inputReader, generatedOutput);
        theObject.setNamespaceEnabled(namespaceEnabled);
        theObject.setRecover(recover);
        theObject.setIndent(indent);
        theObject.run();
        String s = System.getProperty("line.separator");
        System.out.print(s + "Transformation complete" + s);
    }

    public boolean isNamespaceEnabled() {
        return this.namespaceEnabled;
    }

    public void setNamespaceEnabled(boolean namespaceEnabled) {
        this.namespaceEnabled = namespaceEnabled;
    }

    public void setRecover(boolean recover) {
        this.recover = recover;
    }

    public void setIndent(boolean indent) {
        if (indent && !(this.generatedOutput instanceof XmlFormatter)) {
            this.generatedOutput = new XmlFormatter(this.generatedOutput);
        }
    }

    static class IgnoreSyntaxExceptions
    implements EDISyntaxExceptionHandler {
        IgnoreSyntaxExceptions() {
        }

        @Override
        public boolean process(RecoverableSyntaxException syntaxException) {
            System.out.println("Syntax Exception. class: " + syntaxException.getClass().getName() + "  message:" + syntaxException.getMessage());
            return true;
        }
    }
}

