/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.demo;

import com.berryworks.edireader.EDIReader;
import com.berryworks.edireader.EDIReaderFactory;
import com.berryworks.edireader.demo.EDItoXML;
import java.io.IOException;
import java.io.Reader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EDItoXPATH {
    private final InputSource inputSource;

    public EDItoXPATH(Reader inputReader) {
        this.inputSource = new InputSource(inputReader);
    }

    public void run() {
        try {
            EDIReader ediReader = EDIReaderFactory.createEDIReader(this.inputSource);
            SAXSource source = new SAXSource(ediReader, this.inputSource);
            DOMResult domResult = new DOMResult();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(source, domResult);
            Node document = domResult.getNode();
            XPath xPath = XPathFactory.newInstance().newXPath();
            String query = "/ediroot/interchange/group/transaction/@DocType";
            String xPathResult = xPath.evaluate(query, document);
            System.out.print("\nXPath query " + query + " produces result " + xPathResult + "\n");
        }
        catch (SAXException e) {
            System.err.println("\nUnable to create EDIReader: " + e);
        }
        catch (TransformerConfigurationException e) {
            System.err.println("\nUnable to create Transformer: " + e);
        }
        catch (TransformerException e) {
            System.err.println("\nUnable to transform EDI into DOM: " + e);
        }
        catch (IOException e) {
            System.err.println("\nUnable to read EDI input: " + e);
        }
        catch (XPathExpressionException e) {
            System.err.println("\nInvalid XPath expression: " + e);
        }
    }

    public static void main(String[] args) {
        String inputFileName = null;
        if (args.length == 1) {
            inputFileName = args[0];
        } else {
            EDItoXPATH.badArgs();
        }
        Reader inputReader = EDItoXML.establishInput(inputFileName);
        EDItoXPATH theObject = new EDItoXPATH(inputReader);
        theObject.run();
    }

    private static void badArgs() {
        System.err.println("Usage: EDItoXPATH inputfile");
        throw new RuntimeException("Missing or invalid command line arguments");
    }
}

