/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.formatter;

import com.berryworks.edireader.EDIReader;
import com.berryworks.edireader.util.sax.EDIReaderSAXAdapter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import org.xml.sax.Attributes;

public class FormatterHandler
extends EDIReaderSAXAdapter {
    private final Reader input;
    protected final PrintWriter output;
    protected final EDIReader ediReader;
    protected String indent;
    private String filename;
    private int charsReadSoFar;

    public FormatterHandler(EDIReader reader, Reader input, PrintWriter output) {
        super(reader.getXMLTags());
        this.ediReader = reader;
        this.input = input;
        this.output = output;
    }

    @Override
    protected void beginInterchange(int charCount, int segmentCharCount, Attributes attributes) {
        this.indent = "";
        String segment = this.readSegment(charCount - segmentCharCount, segmentCharCount);
        this.output.println(this.indent + segment);
    }

    @Override
    protected void endInterchange(int charCount, int segmentCharCount) {
        this.indent = "";
        String segment = this.readSegment(charCount - segmentCharCount, segmentCharCount);
        this.output.println(this.indent + segment);
    }

    @Override
    protected void beginExplicitGroup(int charCount, int segmentCharCount, Attributes attributes) {
        this.indent = "   ";
        String segment = this.readSegment(charCount - segmentCharCount, segmentCharCount);
        this.output.println(this.indent + segment);
    }

    @Override
    protected void endExplicitGroup(int charCount, int segmentCharCount) {
        this.indent = "   ";
        String segment = this.readSegment(charCount - segmentCharCount, segmentCharCount);
        this.output.println(this.indent + segment);
    }

    @Override
    protected void beginImplicitGroup() {
        this.indent = "   ";
        this.endImplicitGroup();
    }

    @Override
    protected void endImplicitGroup() {
        this.output.println(this.indent + "...");
    }

    @Override
    protected void beginSegmentGroup(String loopName, Attributes atts) {
        this.output.println(this.indent + "+------ " + loopName);
        this.indent = this.indent + "|  ";
    }

    @Override
    protected void beginAnotherSegment(Attributes atts) {
        super.beginAnotherSegment(atts);
    }

    @Override
    protected void beginFirstSegment(Attributes atts) {
        this.indent = this.indent + "   ";
    }

    @Override
    protected void beginDocument(int charCount, int segmentCharCount, Attributes attributes) {
        this.indent = "      ";
        String segment = this.readSegment(charCount - segmentCharCount, segmentCharCount);
        this.output.println(this.indent + segment);
    }

    @Override
    protected void endDocument(int charCount, int segmentCharCount) {
        this.indent = "      ";
        String segment = this.readSegment(charCount - segmentCharCount, segmentCharCount);
        this.output.println(this.indent + segment);
    }

    @Override
    protected void beginImplicitDocument() {
        this.indent = "     ";
    }

    @Override
    protected void endSegment(int charCount, int segmentCharCount) {
        String segment = this.readSegment(charCount - segmentCharCount, segmentCharCount);
        this.output.println(this.indent + segment);
    }

    @Override
    protected void endSegmentGroup() {
        this.indent = this.indent.substring(0, this.indent.length() - 3);
        this.output.println(this.indent + "+-----------");
    }

    protected String readSegment(int offset, int length) {
        int i;
        char[] buf;
        if (this.charsReadSoFar < offset) {
            int toSkip = offset - this.charsReadSoFar;
            while (toSkip > 0) {
                try {
                    long n;
                    if (!this.input.ready()) {
                        Thread.yield();
                    }
                    if ((n = this.input.skip(toSkip)) <= 0L) continue;
                    toSkip = (int)((long)toSkip - n);
                    this.charsReadSoFar = (int)((long)this.charsReadSoFar + n);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unexpected skip exception on duplicate pipe ", e);
                }
            }
        }
        if (this.charsReadSoFar == offset) {
            buf = new char[length];
            int n = 0;
            while (n < length) {
                try {
                    int i2;
                    if (!this.input.ready()) {
                        Thread.yield();
                    }
                    if ((i2 = this.input.read(buf, n, length - n)) != -1) {
                        if (i2 < length - n) {
                            Thread.yield();
                        }
                        if (i2 <= 0) continue;
                        n += i2;
                        this.charsReadSoFar += i2;
                        continue;
                    }
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unexpected read exception on duplicate pipe ", e);
                }
            }
        } else {
            throw new RuntimeException("Unexpected attempt to skip backwards");
        }
        for (i = buf.length; i > 0 && ("\n\r \\".indexOf(buf[i - 1]) >= 0 || Character.isISOControl(buf[i - 1])); --i) {
        }
        return new String(buf, 0, i);
    }

    @Override
    protected void recover(Exception e) {
        System.err.println("recovering from " + e.getMessage());
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public int getSegmentCharCount() {
        int n = super.getSegmentCharCount();
        return n == -1 ? this.ediReader.getSegmentCharCount() : n;
    }

    @Override
    public int getCharCount() {
        int n = super.getCharCount();
        return n == -1 ? this.ediReader.getCharCount() : n;
    }

    public void start(String uri, String name, String data, Attributes attributes) {
    }

    public void end(String uri, String name) {
    }

    @Override
    public void preface() {
    }

    @Override
    public void addendum() {
    }
}

