/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.plugin;

import com.berryworks.edireader.Plugin;
import com.berryworks.edireader.PluginController;
import com.berryworks.edireader.plugin.PluginControllerFactoryInterface;
import com.berryworks.edireader.plugin.PluginControllerImpl;
import com.berryworks.edireader.tokenizer.Tokenizer;
import com.berryworks.edireader.util.FixedLength;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPluginControllerFactory
implements PluginControllerFactoryInterface {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getSimpleName());
    protected static final Map<String, Plugin> pluginCache = new HashMap<String, Plugin>();
    protected static boolean debug;
    protected String lastPluginLoaded = null;
    protected PluginController lastPluginController;

    public String getLastPluginLoaded() {
        return this.lastPluginLoaded;
    }

    @Override
    public PluginController create(String standard, String docType, Tokenizer tokenizer) {
        return this.create(standard, docType, null, null, tokenizer);
    }

    protected Plugin loadPlugin(String standard, String docType, String docVersion, String docRelease) {
        Plugin result = null;
        String key = standard + "_" + docType + "_" + docVersion + "_" + docRelease;
        if (pluginCache.containsKey(key)) {
            if (debug) {
                logger.debug("plugin for {} found in cache", (Object)key);
            }
            this.lastPluginLoaded = key;
            result = pluginCache.get(key);
        } else {
            String suffix = System.getProperty("EDIREADER_PLUGIN_SUFFIX");
            if (FixedLength.isPresent(docVersion) && FixedLength.isPresent(docRelease)) {
                if (FixedLength.isPresent(suffix)) {
                    result = this.lookForSpecificPlugin(standard, docVersion + "_" + docRelease + "." + standard + "_" + docType + "_" + suffix);
                }
                if (result == null) {
                    result = this.lookForSpecificPlugin(standard, docVersion + "_" + docRelease + "." + standard + "_" + docType);
                }
                if (FixedLength.isPresent(suffix)) {
                    result = this.lookForSpecificPlugin(standard, docType + "_" + docVersion + "_" + docRelease + "_" + suffix);
                }
                if (result == null) {
                    result = this.lookForSpecificPlugin(standard, docType + "_" + docVersion + "_" + docRelease);
                }
            }
            if (result == null && FixedLength.isPresent(suffix)) {
                result = this.lookForSpecificPlugin(standard, docType + "_" + suffix);
            }
            if (result == null) {
                result = this.lookForSpecificPlugin(standard, docType);
            }
            if (result != null) {
                pluginCache.put(key, result);
            }
        }
        return result;
    }

    @Override
    public PluginController getLastControllerCreated() {
        return this.lastPluginController;
    }

    public void clearCache() {
        pluginCache.clear();
    }

    @Override
    public PluginController create(String standard, String docType, String docVersion, String docRelease, Tokenizer tokenizer) {
        PluginControllerImpl result;
        Plugin plugin = this.loadPlugin(standard, docType, docVersion, docRelease);
        if (plugin == null) {
            result = new PluginControllerImpl(standard, tokenizer);
            result.setEnabled(false);
        } else {
            plugin.init();
            result = plugin.createController(standard, tokenizer);
            result.setEnabled(true);
        }
        result.setDocumentType(docType);
        result.setPlugin(plugin);
        this.lastPluginController = result;
        return result;
    }

    protected abstract Plugin lookForSpecificPlugin(String var1, String var2);

    protected abstract Plugin getInstance(String var1, String var2) throws Exception;
}

