/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.plugin;

import java.util.HashSet;
import java.util.Set;

public class LoopContext {
    private final String loopName;
    private int segmentPosition;
    private int segmentRepetitions;
    private Set<String> mandatorySegments;

    public LoopContext(String loopName) {
        this.loopName = loopName;
        this.segmentPosition = 0;
        this.segmentRepetitions = 0;
        this.mandatorySegments = new HashSet<String>();
    }

    public void noteSegmentPresence(String segmentName) {
        this.mandatorySegments.remove(segmentName);
    }

    public boolean isMandatorySegmentValidationSatisfied() {
        return this.mandatorySegments.isEmpty();
    }

    public String toString() {
        return "LoopContext loopName:" + this.loopName + " position:" + this.segmentPosition + " repetitions:" + this.segmentRepetitions + " mandatory:" + this.getMandatorySegmentsRemaining();
    }

    public String getLoopName() {
        return this.loopName;
    }

    public int getSegmentPosition() {
        return this.segmentPosition;
    }

    public void setSegmentPosition(int segmentPosition) {
        this.segmentPosition = segmentPosition;
    }

    public int getSegmentRepetitions() {
        return this.segmentRepetitions;
    }

    public void setSegmentRepetitions(int segmentRepetitions) {
        this.segmentRepetitions = segmentRepetitions;
    }

    public String getMandatorySegmentsRemaining() {
        StringBuilder result = new StringBuilder();
        for (String mandatorySegment : this.mandatorySegments) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append((Object)mandatorySegment);
        }
        return result.toString();
    }

    public void setMandatorySegments(Set<String> segmentSet) {
        this.mandatorySegments = segmentSet;
    }
}

