/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.plugin;

import com.berryworks.edireader.util.FixedLength;
import java.util.Set;
import java.util.TreeSet;

public class LoopDescriptor {
    public static final int UNSPECIFIED = -1;
    protected String name;
    protected final String firstSegment;
    protected final int nestingLevel;
    protected final int minimumOccurrences;
    protected final int maximumOccurrences;
    protected String loopContext;
    private final int levelContext;
    private final Set<String> resultFlags = new TreeSet<String>();
    private final Set<String> conditionFlags = new TreeSet<String>();

    public LoopDescriptor(String loopName, String firstSegment, int nestingLevel, String currentLoop) {
        this(loopName, firstSegment, nestingLevel, currentLoop, -1, -1);
    }

    public LoopDescriptor(String loopName, String firstSegment, int nestingLevel, String currentLoop, int minimumOccurrences, int maximumOccurrences) {
        this.name = loopName;
        this.firstSegment = firstSegment;
        this.nestingLevel = nestingLevel;
        this.loopContext = currentLoop;
        this.levelContext = -1;
        this.minimumOccurrences = minimumOccurrences;
        this.maximumOccurrences = maximumOccurrences;
        this.lookForFlags();
    }

    public LoopDescriptor(String loopName, String firstSegment, int nestingLevel) {
        this(loopName, firstSegment, nestingLevel, "*");
    }

    public LoopDescriptor(String loopName, String firstSegment) {
        this(loopName, firstSegment, 1, "/");
    }

    public LoopDescriptor(String loopName, String firstSegment, int nestingLevel, int currentLevel) {
        this.name = loopName;
        this.firstSegment = firstSegment;
        this.nestingLevel = nestingLevel;
        this.loopContext = "*";
        this.levelContext = currentLevel;
        this.maximumOccurrences = -1;
        this.minimumOccurrences = -1;
        this.lookForFlags();
    }

    private void lookForFlags() {
        int indexOfFirstQuestion;
        boolean first;
        int indexOfFirstPlus;
        if (FixedLength.isPresent(this.name) && (indexOfFirstPlus = this.name.indexOf(43)) > 0) {
            first = true;
            for (String part : this.name.split("\\+")) {
                if (first) {
                    this.name = part;
                    first = false;
                    continue;
                }
                this.resultFlags.add(part);
            }
        }
        if (FixedLength.isPresent(this.loopContext) && (indexOfFirstQuestion = this.loopContext.indexOf(63)) > 0) {
            first = true;
            for (String part : this.loopContext.split("\\?")) {
                if (first) {
                    this.loopContext = part;
                    first = false;
                    continue;
                }
                this.conditionFlags.add(part);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public int getNestingLevel() {
        return this.nestingLevel;
    }

    public String getLoopContext() {
        return this.loopContext;
    }

    public int getLevelContext() {
        return this.levelContext;
    }

    public int getMinimumOccurrences() {
        return this.minimumOccurrences;
    }

    public int getMaximumOccurrences() {
        return this.maximumOccurrences;
    }

    public String getFirstSegment() {
        return this.firstSegment;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("loop " + this.getName() + " at nesting level " + this.getNestingLevel() + ": encountering segment " + this.getFirstSegment());
        String context = this.getLoopContext();
        switch (context) {
            case "*": {
                result.append(" anytime");
                break;
            }
            case "/": {
                result.append(" while outside any loop");
                break;
            }
            default: {
                result.append(" while currently in loop ").append(context);
            }
        }
        if (this.levelContext > -1) {
            result.append(" while current at nesting level ").append(this.levelContext);
        }
        if (!this.resultFlags.isEmpty()) {
            result.append(", setting");
            for (String flagName : this.resultFlags) {
                result.append(" ").append(flagName);
            }
        }
        if (!this.conditionFlags.isEmpty()) {
            result.append(", conditional based on");
            for (String flagName : this.conditionFlags) {
                result.append(" ").append(flagName);
            }
        }
        return result.toString();
    }

    public boolean equals(Object target) {
        if (!(target instanceof LoopDescriptor)) {
            return false;
        }
        LoopDescriptor sld = (LoopDescriptor)target;
        return this.equalsOrBothNull(this.getName(), sld.getName()) && this.equalsOrBothNull(this.getFirstSegment(), sld.getFirstSegment()) && this.getNestingLevel() == sld.getNestingLevel() && this.getLoopContext().equals(sld.getLoopContext()) && this.getLevelContext() == sld.getLevelContext() && this.getMinimumOccurrences() == sld.getMinimumOccurrences() && this.getMaximumOccurrences() == sld.getMaximumOccurrences() && this.getResultFlags().equals(sld.getResultFlags()) && this.getConditionFlags().equals(sld.getConditionFlags());
    }

    public int hashCode() {
        return this.getName().hashCode() + this.getFirstSegment().hashCode();
    }

    private boolean equalsOrBothNull(String value1, String value2) {
        return value1 == null && value2 == null || value1 != null && value1.equals(value2);
    }

    public boolean isAnyContext() {
        return "*".equals(this.loopContext);
    }

    public boolean isResultFlag(String flagName) {
        return this.resultFlags.contains(flagName);
    }

    public Set<String> getResultFlags() {
        return this.resultFlags;
    }

    public boolean isConditionFlag(String flagName) {
        return this.conditionFlags.contains(flagName);
    }

    public Set<String> getConditionFlags() {
        return this.conditionFlags;
    }
}

