/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.plugin;

import com.berryworks.edireader.Plugin;
import com.berryworks.edireader.plugin.AbstractPluginControllerFactory;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginControllerFactory
extends AbstractPluginControllerFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getSimpleName());
    public static final String DEFAULT_EDIREADER_PLUGIN_PACKAGE = "com.berryworks.edireader.plugin";

    @Override
    protected Plugin lookForSpecificPlugin(String standard, String docType) {
        Plugin pluginFound = null;
        try {
            pluginFound = this.getInstance(standard, docType);
            logger.info("Plugin found for document type {}: {}", (Object)docType, (Object)pluginFound.getDocumentName());
        }
        catch (ClassNotFoundException e) {
            logger.debug("plugin for {} not available", (Object)docType);
        }
        catch (InstantiationException e) {
            logger.debug("plugin for {} could not be instantiated", (Object)docType);
        }
        catch (IllegalAccessException e) {
            logger.debug("plugin for {} caused IllegalAccessException {}", (Object)docType, (Object)e.getMessage());
        }
        catch (Exception e) {
            logger.debug("plugin for {} threw {}", (Object)docType, (Object)e.getMessage());
        }
        return pluginFound;
    }

    @Override
    protected Plugin getInstance(String standard, String docType) throws Exception {
        String pluginName = PluginControllerFactory.pluginPackage() + "." + standard + "_" + docType;
        logger.debug("attempting to load a plugin named {}", (Object)pluginName);
        Class<?> pluginClass = Class.forName(pluginName);
        logger.debug("plugin loaded");
        Plugin instance = (Plugin)pluginClass.newInstance();
        instance.prepare();
        this.lastPluginLoaded = pluginName;
        return instance;
    }

    protected static String pluginPackage() {
        String packageName = System.getProperty("EDIREADER_PLUGIN_PACKAGE");
        if (packageName == null) {
            packageName = DEFAULT_EDIREADER_PLUGIN_PACKAGE;
            logger.debug("Plugin package defaults to {}", (Object)packageName);
        } else {
            logger.debug("Plugin package set by property to {}", (Object)packageName);
        }
        return packageName;
    }
}

