/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.plugin;

import com.berryworks.edireader.EDISyntaxException;
import com.berryworks.edireader.Plugin;
import com.berryworks.edireader.PluginController;
import com.berryworks.edireader.plugin.LoopContext;
import com.berryworks.edireader.plugin.LoopDescriptor;
import com.berryworks.edireader.plugin.LoopStack;
import com.berryworks.edireader.tokenizer.Tokenizer;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginControllerImpl
extends PluginController {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getSimpleName());
    protected boolean enabled;
    protected final String standard;
    protected String documentType;
    protected Plugin plugin;
    protected LoopStack loopStack;
    protected final Tokenizer tokenizer;
    protected String currentLoopName;
    protected LoopDescriptor loopDescriptor;
    protected int numberOfLoopsClosed;
    private final Set<String> resultFlags = new HashSet<String>();

    public PluginControllerImpl(String standard, Tokenizer tokenizer) {
        this.standard = standard;
        this.tokenizer = tokenizer;
        this.reset();
    }

    @Override
    public void reset() {
        this.loopStack = new LoopStack();
        this.currentLoopName = "/";
        this.loopDescriptor = new LoopDescriptor(this.currentLoopName, "", 0, "/");
    }

    @Override
    public boolean transition(String segmentName) throws EDISyntaxException {
        if (!this.enabled) {
            return false;
        }
        if (debug) {
            logger.debug("considering segment {} while in loop {} with stack {}", new Object[]{segmentName, this.loopDescriptor.getName(), this.loopStack.toString()});
        }
        boolean result = false;
        LoopDescriptor newDescriptor = this.plugin.query(segmentName, this.loopStack.toString(), this.loopDescriptor.getNestingLevel(), this.resultFlags);
        if (debug) {
            logger.debug("considering segment {} using descriptor {}", (Object)segmentName, (Object)newDescriptor);
        }
        if (!this.validateDescriptor(newDescriptor, segmentName, this.tokenizer)) {
            return false;
        }
        Set<String> flags = newDescriptor.getResultFlags();
        for (String flagName : flags) {
            logger.debug("setting flag {}", (Object)flagName);
            this.resultFlags.add(flagName);
        }
        String newLoopName = newDescriptor.getName();
        if (".".equals(newLoopName) && newDescriptor.getNestingLevel() == this.loopDescriptor.getNestingLevel()) {
            logger.debug("resuming current loop without transition");
        } else {
            logger.debug("transitioning to level {}", (Object)newDescriptor.getNestingLevel());
            result = true;
            this.numberOfLoopsClosed = this.loopDescriptor.getNestingLevel() - newDescriptor.getNestingLevel();
            boolean resumeLoop = true;
            if (newLoopName.startsWith("/")) {
                this.currentLoopName = newLoopName;
            } else if (newLoopName.startsWith(".")) {
                this.currentLoopName = newDescriptor.getNestingLevel() == 0 ? "/" : ".";
            } else {
                ++this.numberOfLoopsClosed;
                this.currentLoopName = newLoopName;
                resumeLoop = false;
            }
            logger.debug("closing {} loops", (Object)this.numberOfLoopsClosed);
            if (this.numberOfLoopsClosed < 0 || this.numberOfLoopsClosed > this.loopDescriptor.getNestingLevel()) {
                EDISyntaxException se = new EDISyntaxException("Improper sequencing noted with segment " + segmentName, this.tokenizer);
                logger.warn(se.getMessage());
                throw se;
            }
            if (this.numberOfLoopsClosed > 0) {
                for (int i = 0; i < this.numberOfLoopsClosed; ++i) {
                    LoopContext completedLoop = this.loopStack.pop();
                    this.validateCompletedLoop(completedLoop);
                    logger.debug("popped {} off the stack", (Object)completedLoop);
                }
            }
            this.loopDescriptor = newDescriptor;
            if (resumeLoop) {
                if (debug) {
                    logger.debug("resuming loop at level {} with name {} ", (Object)this.loopDescriptor.getNestingLevel(), (Object)this.loopDescriptor.getName());
                }
                if (this.loopDescriptor.getNestingLevel() == 0 && this.loopDescriptor.getName().length() > 1 && this.loopDescriptor.getName().startsWith("/")) {
                    logger.debug("special legacy case: {}", (Object)this.loopDescriptor);
                    this.loopStack.setBottom(new LoopContext(this.loopDescriptor.getName().substring(1)));
                }
            } else {
                this.loopStack.push(this.createLoopContext(this.loopDescriptor.getName(), this.plugin, this.loopStack.toString()));
                logger.debug("pushed {} onto the stack", (Object)this.loopDescriptor.getName());
            }
        }
        return this.validateSegment(newDescriptor, this.loopStack, this.tokenizer) && result;
    }

    protected LoopContext createLoopContext(String name, Plugin plugin, String stack) {
        return new LoopContext(name);
    }

    protected boolean validateDescriptor(LoopDescriptor descriptor, String segmentName, Tokenizer tokenizer) throws EDISyntaxException {
        return descriptor != null;
    }

    protected void validateCompletedLoop(LoopContext completedLoop) throws EDISyntaxException {
    }

    protected boolean validateSegment(LoopDescriptor descriptor, LoopStack loopStack, Tokenizer tokenizer) throws EDISyntaxException {
        return true;
    }

    protected LoopStack getLoopStack() {
        return this.loopStack;
    }

    @Override
    public String getLoopEntered() {
        return this.currentLoopName;
    }

    @Override
    public int closedCount() {
        return this.numberOfLoopsClosed;
    }

    @Override
    public int getNestingLevel() {
        return this.loopDescriptor.getNestingLevel();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getDocumentName() {
        return this.enabled ? this.plugin.getDocumentName() : null;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    public void setPlugin(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean isResumed() {
        String s = this.getLoopEntered();
        return s.startsWith("/") || ".".equals(s);
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }
}

