/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.splitter;

import com.berryworks.edireader.DefaultXMLTags;
import com.berryworks.edireader.EDIAttributes;
import com.berryworks.edireader.EDIReader;
import com.berryworks.edireader.EDIReaderFactory;
import com.berryworks.edireader.SyntaxDescriptor;
import com.berryworks.edireader.XMLTags;
import com.berryworks.edireader.error.EDISyntaxExceptionHandler;
import com.berryworks.edireader.error.RecoverableSyntaxException;
import com.berryworks.edireader.filter.EdiReaderFilter;
import com.berryworks.edireader.plugin.AbstractPluginControllerFactory;
import com.berryworks.edireader.splitter.ClosingDetails;
import com.berryworks.edireader.splitter.HandlerFactory;
import com.berryworks.edireader.splitter.SplittingLevel;
import com.berryworks.edireader.util.FixedLength;
import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class SplittingHandler
extends DefaultHandler {
    protected final XMLTags xmlTags = DefaultXMLTags.getInstance();
    protected final String interchangeTagName = this.xmlTags.getInterchangeTag();
    protected final String senderTagName = this.xmlTags.getSenderTag();
    protected final String receiverTagName = this.xmlTags.getReceiverTag();
    protected final String addressTagName = this.xmlTags.getAddressTag();
    protected final HandlerFactory handlerFactory;
    protected SplittingLevel level;
    protected ContentHandler contentHandler;
    protected boolean pendingDocumentClose;
    protected boolean senderAddress;
    protected Attributes interchangeAttributes;
    protected Attributes senderAttributes;
    protected Attributes receiverAttributes;
    protected Attributes groupAttributes;
    protected Attributes documentAttributes;
    protected final Attributes emptyAttributes = new AttributesImpl();
    protected int transactionsInInterchangeCount;
    protected int transactionsInGroupCount;
    protected int segmentCount;
    protected int transactionCountLimit;
    protected int segmentCountLimit;
    protected AbstractPluginControllerFactory pluginControllerFactory;
    protected EdiReaderFilter filter;
    protected SyntaxDescriptor syntaxDescriptor;

    public SplittingHandler(HandlerFactory handlerFactory) {
        this.handlerFactory = handlerFactory;
    }

    public void split(InputSource inputSource) throws IOException, SAXException {
        EDIReader parser;
        char[] leftOver = null;
        while ((parser = EDIReaderFactory.createEDIReader(inputSource, leftOver)) != null) {
            this.noteSyntaxDetails(parser);
            parser.setContentHandler(this);
            parser.setSyntaxExceptionHandler(new MyErrorHandler());
            if (this.pluginControllerFactory != null) {
                parser.setPluginControllerFactory(this.pluginControllerFactory);
            }
            if (this.filter != null) {
                EDIReader f = this.filter.filter(parser);
                f.parse(inputSource);
            } else {
                parser.parse(inputSource);
            }
            leftOver = parser.getTokenizer().getBuffered();
        }
        this.handlerFactory.markEndOfStream();
    }

    protected void noteSyntaxDetails(EDIReader parser) {
        this.syntaxDescriptor = new SyntaxDescriptor();
        this.syntaxDescriptor.setDelimiter(parser.getDelimiter());
        this.syntaxDescriptor.setSubDelimiter(parser.getSubDelimiter());
        this.syntaxDescriptor.setTerminator(parser.getTerminator());
        this.syntaxDescriptor.setTerminatorSuffix(parser.getTerminatorSuffix());
        this.syntaxDescriptor.setRelease(parser.getRelease());
        this.syntaxDescriptor.setDecimalMark(parser.getDecimalMark());
        this.syntaxDescriptor.setRepetitionSeparator(parser.getRepetitionSeparator());
        this.syntaxDescriptor.setSubSubDelimiter(parser.getSubSubDelimiter());
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.contentHandler = this.handlerFactory.createDocument();
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
        this.contentHandler.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.contentHandler.endDocument();
        ClosingDetails closingDetails = new ClosingDetails();
        closingDetails.setSenderQualifier(this.senderAttributes.getValue(this.xmlTags.getQualifierAttribute()));
        closingDetails.setSenderId(this.senderAttributes.getValue(this.xmlTags.getIdAttribute()));
        closingDetails.setReceiverQualifier(this.receiverAttributes.getValue(this.xmlTags.getQualifierAttribute()));
        closingDetails.setReceiverId(this.receiverAttributes.getValue(this.xmlTags.getIdAttribute()));
        closingDetails.setInterchangeControlNumber(this.interchangeAttributes.getValue(this.xmlTags.getControl()));
        closingDetails.setTestIndicator(this.interchangeAttributes.getValue(this.xmlTags.getTestIndicator()));
        closingDetails.setGroupSender(this.groupAttributes.getValue(this.xmlTags.getApplSender()));
        closingDetails.setGroupReceiver(this.groupAttributes.getValue(this.xmlTags.getApplReceiver()));
        closingDetails.setGroupControlNumber(this.groupAttributes.getValue(this.xmlTags.getControl()));
        closingDetails.setDocumentControlNumber(this.documentAttributes.getValue(this.xmlTags.getControl()));
        closingDetails.setDocumentType(this.documentAttributes.getValue(this.xmlTags.getDocumentType()));
        String version = this.groupAttributes.getValue(this.xmlTags.getStandardVersion());
        if (!FixedLength.isPresent(version)) {
            version = this.documentAttributes.getValue(this.xmlTags.getRelease());
        }
        closingDetails.setVersion(version);
        try {
            this.handlerFactory.closeDocument(closingDetails);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.xmlTags.getInterchangeTag().equals(localName)) {
            this.transactionsInInterchangeCount = 0;
            this.segmentCount = 0;
            this.interchangeAttributes = new EDIAttributes(attributes);
        } else if (this.xmlTags.getSenderTag().equals(localName)) {
            this.senderAddress = true;
        } else if (this.xmlTags.getReceiverTag().equals(localName)) {
            this.senderAddress = false;
        } else if (this.xmlTags.getAddressTag().equals(localName)) {
            if (this.senderAddress) {
                this.senderAttributes = new EDIAttributes(attributes);
            } else {
                this.receiverAttributes = new EDIAttributes(attributes);
            }
        } else if (this.xmlTags.getGroupTag().equals(localName)) {
            this.transactionsInGroupCount = 0;
            if (this.pendingDocumentClose) {
                this.generateArtificialBoundaryForNewGroup();
                this.pendingDocumentClose = false;
            }
            this.groupAttributes = new EDIAttributes(attributes);
            this.documentAttributes = null;
        } else if (this.xmlTags.getDocumentTag().equals(localName)) {
            if (this.pendingDocumentClose) {
                this.generateArtificialBoundaryForNewDocument();
                this.pendingDocumentClose = false;
            }
            this.documentAttributes = new EDIAttributes(attributes);
        } else if (this.xmlTags.getSegTag().equals(localName)) {
            ++this.segmentCount;
        }
        this.contentHandler.startElement(uri, localName, qName, attributes);
    }

    protected void generateArtificialBoundaryForNewDocument() throws SAXException {
        this.pendingDocumentClose = false;
        String groupTagName = this.xmlTags.getGroupTag();
        this.endElement("", groupTagName, groupTagName);
        this.generateArtificialBoundaryForNewGroup();
        this.startElement("", groupTagName, groupTagName, this.groupAttributes);
    }

    protected void generateArtificialBoundaryForNewGroup() throws SAXException {
        this.pendingDocumentClose = false;
        this.endElement("", this.interchangeTagName, this.interchangeTagName);
        String rootTagName = this.xmlTags.getRootTag();
        this.endElement("", rootTagName, rootTagName);
        this.endDocument();
        this.startDocument();
        this.startElement("", rootTagName, rootTagName, this.emptyAttributes);
        this.startElement("", this.interchangeTagName, this.interchangeTagName, this.interchangeAttributes);
        this.startElement("", this.senderTagName, this.senderTagName, this.emptyAttributes);
        this.startElement("", this.addressTagName, this.addressTagName, this.senderAttributes);
        this.endElement("", this.addressTagName, this.addressTagName);
        this.endElement("", this.senderTagName, this.senderTagName);
        this.startElement("", this.receiverTagName, this.receiverTagName, this.emptyAttributes);
        this.startElement("", this.addressTagName, this.addressTagName, this.receiverAttributes);
        this.endElement("", this.addressTagName, this.addressTagName);
        this.endElement("", this.receiverTagName, this.receiverTagName);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.contentHandler.endElement(uri, localName, qName);
        if (this.xmlTags.getDocumentTag().equals(localName)) {
            ++this.transactionsInInterchangeCount;
            ++this.transactionsInGroupCount;
            if (this.transactionsInInterchangeCount >= this.transactionCountLimit) {
                this.pendingDocumentClose = true;
            } else if (this.segmentCountLimit > 0 && this.segmentCount >= this.segmentCountLimit) {
                this.pendingDocumentClose = true;
            }
        } else if (this.xmlTags.getInterchangeTag().equals(localName)) {
            this.pendingDocumentClose = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.contentHandler.characters(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.contentHandler.processingInstruction(target, data);
    }

    public void setTransactionCountLimit(int transactionCountLimit) {
        this.transactionCountLimit = transactionCountLimit;
    }

    public void setSegmentCountLimit(int limit) {
        this.segmentCountLimit = limit;
    }

    public void setPluginControllerFactory(AbstractPluginControllerFactory pluginControllerFactory) {
        this.pluginControllerFactory = pluginControllerFactory;
    }

    public AbstractPluginControllerFactory getPluginControllerFactory() {
        return this.pluginControllerFactory;
    }

    public void setFilter(EdiReaderFilter filter) {
        this.filter = filter;
    }

    public EdiReaderFilter getFilter() {
        return this.filter;
    }

    public HandlerFactory getHandlerFactory() {
        return this.handlerFactory;
    }

    public SyntaxDescriptor getSyntaxDescriptor() {
        return this.syntaxDescriptor;
    }

    public SplittingLevel getLevel() {
        return this.level;
    }

    public void setLevel(SplittingLevel level) {
        this.level = level;
    }

    protected static class MyErrorHandler
    implements EDISyntaxExceptionHandler {
        protected MyErrorHandler() {
        }

        @Override
        public boolean process(RecoverableSyntaxException syntaxException) {
            return true;
        }
    }
}

