/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.tokenizer;

import com.berryworks.edireader.EDISyntaxException;
import com.berryworks.edireader.error.ErrorMessages;
import com.berryworks.edireader.tokenizer.Token;
import com.berryworks.edireader.tokenizer.TokenImpl;
import com.berryworks.edireader.tokenizer.Tokenizer;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class AbstractTokenizer
implements Tokenizer,
ErrorMessages {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getSimpleName());
    protected CharacterClass cClass;
    protected State state;
    protected Writer outputWriter = null;
    protected boolean writingSuspended;
    protected final StringBuilder recording = new StringBuilder();
    protected boolean recorderOn;
    protected int segmentCount;
    protected int segTokenCount;
    protected int charCount;
    protected int segCharCount;
    protected final Reader inputReader;
    protected char delimiter = (char)43;
    protected char subDelimiter = (char)58;
    protected char subSubDelimiter = (char)38;
    protected int release = -1;
    protected int repetitionSeparator = -1;
    protected char terminator = (char)46;
    protected boolean tokenReady;
    protected boolean repetition;
    protected boolean endOfFile;
    protected final Token currentToken;
    protected char cChar;
    protected boolean unGot;

    @Override
    public int getSegmentCount() {
        return this.segmentCount;
    }

    @Override
    public int getElementInSegmentCount() {
        return this.segTokenCount;
    }

    @Override
    public int getCharCount() {
        return this.charCount;
    }

    @Override
    public int getSegmentCharCount() {
        return this.segCharCount;
    }

    @Override
    public void setCharCounts(int charCount, int segmentCharCount) {
        this.charCount = charCount;
        this.segCharCount = segmentCharCount;
    }

    @Override
    public Reader getReader() {
        return this.inputReader;
    }

    @Override
    public char getSubSubDelimiter() {
        return this.subSubDelimiter;
    }

    @Override
    public void setSubSubDelimiter(char ssd) {
        this.subSubDelimiter = ssd;
    }

    @Override
    public void setRelease(int e) {
        this.release = e;
    }

    @Override
    public int getRepetitionSeparator() {
        return this.repetitionSeparator;
    }

    @Override
    public void setRepetitionSeparator(int e) {
        this.repetitionSeparator = e > 0 ? e : -1;
    }

    @Override
    public void setTerminator(char d) {
        this.terminator = d;
    }

    @Override
    public char getTerminator() {
        return this.terminator;
    }

    @Override
    public char getDelimiter() {
        return this.delimiter;
    }

    @Override
    public void setDelimiter(char d) {
        this.delimiter = d;
    }

    @Override
    public char getSubDelimiter() {
        return this.subDelimiter;
    }

    @Override
    public void setSubDelimiter(char sd) {
        this.subDelimiter = sd;
    }

    public void copy(char c) {
        if (this.outputWriter != null) {
            try {
                this.outputWriter.write(c);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isEndOfData() {
        return this.endOfFile;
    }

    @Override
    public String nextSimpleValue(boolean required, boolean returnNullAtSegmentEnd) throws SAXException, IOException {
        Token t = Token.TokenType.SEGMENT_END == this.currentToken.getType() ? this.currentToken : this.nextToken();
        switch (t.getType()) {
            case EMPTY: {
                if (!required) break;
                EDISyntaxException se = new EDISyntaxException("Mandatory element missing in " + t.getSegmentType() + " segment", this);
                logger.warn(se.getMessage());
                throw se;
            }
            case SEGMENT_END: {
                if (required) {
                    EDISyntaxException se = new EDISyntaxException("Mandatory element missing in " + t.getSegmentType() + " segment", this);
                    logger.warn(se.getMessage());
                    throw se;
                }
                if (!returnNullAtSegmentEnd) break;
                return null;
            }
            case SIMPLE: {
                break;
            }
            default: {
                EDISyntaxException se = new EDISyntaxException("Expected a simple token", this);
                logger.warn(se.getMessage());
                throw se;
            }
        }
        return t.getValue();
    }

    @Override
    public String nextSimpleValue(boolean required) throws SAXException, IOException {
        return this.nextSimpleValue(required, false);
    }

    @Override
    public String nextSimpleValue() throws SAXException, IOException {
        return this.nextSimpleValue(true);
    }

    @Override
    public int nextIntValue() throws SAXException, IOException {
        return this.nextIntValue(false);
    }

    @Override
    public int nextIntValue(boolean returnZeroIfEmpty) throws SAXException, IOException {
        int i;
        try {
            String value = this.nextSimpleValue(false, true);
            if (value == null) {
                value = "";
            }
            i = value.trim().length() == 0 && returnZeroIfEmpty ? 0 : Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            EDISyntaxException se = new EDISyntaxException("Element must contain only digits", this);
            logger.warn(se.getMessage());
            throw se;
        }
        return i;
    }

    @Override
    public List<String> nextCompositeElement() throws IOException, EDISyntaxException {
        return this.nextCompositeElement(false);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public List<String> nextCompositeElement(boolean returnNullAtSegmentEnd) throws IOException, EDISyntaxException {
        result = new ArrayList<String>();
        block7: while (true) lbl-1000:
        // 3 sources

        {
            t = this.nextToken();
            switch (1.$SwitchMap$com$berryworks$edireader$tokenizer$Token$TokenType[t.getType().ordinal()]) {
                case 4: {
                    result.add(t.getValue());
                    if (!t.isLast()) ** GOTO lbl-1000
                    break block7;
                }
                case 5: {
                    result.add("");
                    if (!t.isLast()) continue block7;
                    break block7;
                }
                case 3: {
                    result.add(t.getValue());
                    break block7;
                }
                case 1: {
                    break block7;
                }
                case 2: {
                    if (!returnNullAtSegmentEnd) break block7;
                    return null;
                }
                default: {
                    se = new EDISyntaxException("Invalid composite element", this);
                    AbstractTokenizer.logger.warn(se.getMessage());
                    throw se;
                }
            }
            break;
        }
        return result;
    }

    @Override
    public void ungetToken() {
        this.tokenReady = true;
    }

    @Override
    public void ungetChar() {
        this.unGot = true;
        --this.charCount;
        --this.segCharCount;
    }

    @Override
    public Token nextToken() throws IOException, EDISyntaxException {
        if (!this.tokenReady) {
            this.advance();
        }
        this.tokenReady = false;
        return this.currentToken;
    }

    @Override
    public boolean hasMoreTokens() throws IOException, EDISyntaxException {
        if (!this.tokenReady) {
            this.advance();
        }
        return this.tokenReady;
    }

    @Override
    public String nextSegment() throws SAXException, IOException {
        Token t;
        Token.TokenType tokenType;
        int i = 0;
        while ((tokenType = (t = this.nextToken()).getType()) != Token.TokenType.SEGMENT_START) {
            if (tokenType == Token.TokenType.END_OF_DATA) {
                EDISyntaxException se = new EDISyntaxException("Unexpected end of data", this);
                logger.warn(se.getMessage());
                throw se;
            }
            if (++i <= 30) continue;
            EDISyntaxException se = new EDISyntaxException("Too many fields for " + t.getSegmentType() + " segment (Segment terminator problem?)", this);
            logger.warn(se.getMessage());
            throw se;
        }
        return t.getSegmentType();
    }

    @Override
    public Token skipSegment() throws SAXException, IOException {
        Token t;
        Token.TokenType tokenType;
        if (Token.TokenType.SEGMENT_END == this.currentToken.getType()) {
            return this.currentToken;
        }
        int i = 0;
        while ((tokenType = (t = this.nextToken()).getType()) != Token.TokenType.SEGMENT_END && tokenType != Token.TokenType.END_OF_DATA) {
            if (++i <= 30) continue;
            EDISyntaxException se = new EDISyntaxException("Too many fields in " + t.getSegmentType() + " segment", this);
            logger.warn(se.getMessage());
            throw se;
        }
        return t;
    }

    protected CharacterClass scanData(int limit) throws IOException, EDISyntaxException {
        block7: while (true) {
            this.getChar();
            switch (this.cClass) {
                case RELEASE: {
                    this.getChar();
                }
                case DATA: {
                    if (--limit == 0) {
                        EDISyntaxException se = new EDISyntaxException("Too many characters in an element (delimiter problem?)", this);
                        logger.warn(se.getMessage());
                        throw se;
                    }
                    this.currentToken.append(this.cChar);
                    continue block7;
                }
                case SUB_DELIMITER: {
                    break block7;
                }
                case REPEAT_DELIMITER: {
                    this.repetition = true;
                    break block7;
                }
                case TERMINATOR: {
                    this.ungetChar();
                }
                default: {
                    this.repetition = false;
                    break block7;
                }
            }
            break;
        }
        return this.cClass;
    }

    protected CharacterClass scanData() throws IOException, EDISyntaxException {
        return this.scanData(0);
    }

    @Override
    public void scanTerminatorSuffix() throws IOException {
        do {
            this.getChar();
        } while (this.cClass != CharacterClass.EOF && "\n\r \\".indexOf(this.cChar) != -1);
        this.ungetChar();
    }

    @Override
    public char[] getChars(int n) throws IOException, EDISyntaxException {
        char[] result = new char[n];
        for (int i = 0; i < n; ++i) {
            this.getChar();
            if (this.cClass == CharacterClass.EOF) {
                EDISyntaxException se = new EDISyntaxException("Encountered end of data unexpectedly after reading " + i + " characters of an expected " + n + " character sequence");
                logger.warn(se.getMessage());
                throw se;
            }
            result[i] = this.cChar;
        }
        return result;
    }

    @Override
    public void setWriter(Writer writer) {
        this.outputWriter = writer;
    }

    @Override
    public String getRecording() {
        return this.recording.toString();
    }

    public void suspendWriting(boolean b) {
        this.writingSuspended = b;
    }

    @Override
    public void setRecorder(boolean b) {
        this.recorderOn = b;
        logger.debug("recorder turned {}", (Object)(b ? "on" : "off"));
    }

    public AbstractTokenizer(Reader source) {
        this.state = State.EXPECTING_SEGMENT;
        this.inputReader = source;
        this.tokenReady = false;
        this.currentToken = new TokenImpl(this);
    }

    protected void advance() throws IOException, EDISyntaxException {
        this.getChar();
        this.tokenReady = true;
        block0 : switch (this.cClass) {
            case RELEASE: {
                this.getChar();
            }
            case DATA: {
                switch (this.state) {
                    case IN_SEGMENT: {
                        ++this.segTokenCount;
                        this.currentToken.setType(Token.TokenType.SIMPLE);
                        this.currentToken.setValue(this.cChar);
                        if (!this.repetition) {
                            this.currentToken.incrementIndex();
                        }
                        this.currentToken.resetSubElementIndex();
                        if (this.scanData() != CharacterClass.SUB_DELIMITER) break block0;
                        this.currentToken.setType(Token.TokenType.SUB_ELEMENT);
                        this.currentToken.setLast(false);
                        this.state = State.IN_COMPOSITE;
                        break block0;
                    }
                    case IN_COMPOSITE: {
                        ++this.segTokenCount;
                        this.currentToken.setType(Token.TokenType.SUB_ELEMENT);
                        this.currentToken.incrementSubElementIndex();
                        this.currentToken.setValue(this.cChar);
                        if (this.scanData() == CharacterClass.SUB_DELIMITER) break block0;
                        this.state = State.IN_SEGMENT;
                        this.currentToken.setLast(true);
                        break block0;
                    }
                }
                ++this.segmentCount;
                this.segTokenCount = 1;
                this.segCharCount = 1;
                this.currentToken.setType(Token.TokenType.SEGMENT_START);
                this.currentToken.setValue(this.cChar);
                this.currentToken.resetIndexes();
                this.scanData(10);
                this.currentToken.setSegmentType(this.currentToken.getValue());
                this.state = State.IN_SEGMENT;
                break;
            }
            case TERMINATOR: {
                switch (this.state) {
                    case IN_COMPOSITE: {
                        this.currentToken.incrementSubElementIndex();
                        this.currentToken.setLast(true);
                        this.currentToken.setType(Token.TokenType.SUB_EMPTY);
                        this.currentToken.resetValue();
                        this.ungetChar();
                        this.state = State.IN_SEGMENT;
                        break block0;
                    }
                }
                this.currentToken.setType(Token.TokenType.SEGMENT_END);
                this.state = State.EXPECTING_SEGMENT;
                this.scanTerminatorSuffix();
                this.currentToken.resetSubElementIndex();
                break;
            }
            case DELIMITER: {
                switch (this.state) {
                    case IN_COMPOSITE: {
                        this.currentToken.incrementSubElementIndex();
                        this.currentToken.setType(Token.TokenType.SUB_EMPTY);
                        this.state = State.IN_SEGMENT;
                        break;
                    }
                    default: {
                        ++this.segTokenCount;
                        this.currentToken.incrementIndex();
                        this.currentToken.resetSubElementIndex();
                        this.currentToken.setType(Token.TokenType.EMPTY);
                    }
                }
                this.repetition = false;
                this.currentToken.setLast(true);
                this.currentToken.resetValue();
                break;
            }
            case SUB_DELIMITER: {
                switch (this.state) {
                    case IN_SEGMENT: {
                        if (!this.repetition) {
                            this.currentToken.incrementIndex();
                        }
                        this.state = State.IN_COMPOSITE;
                        this.currentToken.resetSubElementIndex();
                        break;
                    }
                    case IN_COMPOSITE: {
                        this.currentToken.incrementSubElementIndex();
                    }
                }
                this.currentToken.setLast(false);
                this.currentToken.setType(Token.TokenType.SUB_EMPTY);
                this.currentToken.resetValue();
                break;
            }
            case REPEAT_DELIMITER: {
                switch (this.state) {
                    case IN_COMPOSITE: {
                        this.currentToken.incrementSubElementIndex();
                        this.currentToken.setLast(true);
                        this.currentToken.setType(Token.TokenType.SUB_EMPTY);
                        this.currentToken.resetValue();
                        this.state = State.IN_SEGMENT;
                        this.repetition = true;
                        break;
                    }
                    case IN_SEGMENT: {
                        if (!this.repetition) {
                            this.currentToken.incrementIndex();
                        }
                        this.currentToken.resetSubElementIndex();
                        this.currentToken.setLast(false);
                        this.currentToken.setType(Token.TokenType.EMPTY);
                        this.currentToken.resetValue();
                        this.repetition = true;
                    }
                }
                break;
            }
            case EOF: {
                this.currentToken.setType(Token.TokenType.END_OF_DATA);
                this.tokenReady = false;
            }
        }
    }

    protected static enum CharacterClass {
        DATA,
        DELIMITER,
        SUB_DELIMITER,
        RELEASE,
        TERMINATOR,
        REPEAT_DELIMITER,
        EOF;

    }

    protected static enum State {
        EXPECTING_SEGMENT,
        IN_SEGMENT,
        IN_COMPOSITE;

    }
}

