/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.tokenizer;

import com.berryworks.edireader.tokenizer.AbstractTokenizer;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.nio.Buffer;
import java.nio.CharBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EDITokenizer
extends AbstractTokenizer {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getSimpleName());
    public static final int BUFFER_SIZE = 1000;
    private final CharBuffer charBuffer = CharBuffer.wrap(new char[1000]);

    public EDITokenizer(Reader source) {
        super(source);
        ((Buffer)this.charBuffer).flip();
        logger.debug("Constructed a new EDITokenizer");
    }

    public EDITokenizer(Reader source, char[] preRead) {
        this(source);
        if (preRead == null || preRead.length == 0) {
            return;
        }
        if (preRead.length > this.charBuffer.capacity()) {
            throw new RuntimeException("Attempt to create EDITokenizer with " + preRead.length + " pre-read chars, which is greater than the internal buffer size of " + this.charBuffer.capacity());
        }
        ((Buffer)this.charBuffer).clear();
        this.charBuffer.put(preRead);
        ((Buffer)this.charBuffer).flip();
    }

    public String toString() {
        String result = "tokenizer state:";
        result = result + " segmentCount=" + this.segmentCount;
        result = result + " charCount=" + this.charCount;
        result = result + " segTokenCount=" + this.segTokenCount;
        result = result + " segCharCount=" + this.segCharCount;
        result = result + " currentToken=" + this.currentToken;
        result = result + " buffer.limit=" + this.charBuffer.limit();
        result = result + " buffer.position=" + this.charBuffer.position();
        return result;
    }

    @Override
    public void getChar() throws IOException {
        if (this.unGot) {
            this.unGot = false;
            ++this.charCount;
            ++this.segCharCount;
            return;
        }
        if (this.outputWriter != null && !this.endOfFile && !this.writingSuspended) {
            this.outputWriter.write(this.cChar);
        }
        if (this.recorderOn) {
            this.recording.append(this.cChar);
        }
        if (this.charBuffer.remaining() == 0) {
            this.readUntilBufferProvidesAtLeast(1);
        }
        if (this.endOfFile) {
            this.cClass = AbstractTokenizer.CharacterClass.EOF;
            logger.debug("end-of-file encountered");
        } else {
            this.cChar = this.charBuffer.get();
            this.cClass = this.cChar == this.delimiter ? AbstractTokenizer.CharacterClass.DELIMITER : (this.cChar == this.terminator ? AbstractTokenizer.CharacterClass.TERMINATOR : (this.cChar == this.subDelimiter ? AbstractTokenizer.CharacterClass.SUB_DELIMITER : (this.cChar == this.release ? AbstractTokenizer.CharacterClass.RELEASE : (this.cChar == this.repetitionSeparator ? AbstractTokenizer.CharacterClass.REPEAT_DELIMITER : AbstractTokenizer.CharacterClass.DATA))));
        }
        ++this.charCount;
        ++this.segCharCount;
    }

    @Override
    public char[] getBuffered() {
        char[] result = new char[]{};
        if (this.charBuffer.remaining() == 0 && !this.unGot) {
            return result;
        }
        try {
            int n = this.charBuffer.remaining();
            if (!this.endOfFile || n != 0) {
                n += this.unGot ? 1 : 0;
            }
            result = this.lookahead(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public char[] lookahead(int n) throws IOException {
        logger.debug("EDITokenizer.lookahead({})", (Object)n);
        char[] rval = new char[n];
        this.getChar();
        rval[0] = this.cChar;
        this.ungetChar();
        if (this.charBuffer.remaining() < n - 1) {
            logger.debug("Buffering more data to satisfy lookahead({}})", (Object)n);
            this.readUntilBufferProvidesAtLeast(n - 1);
        }
        int j = 1;
        for (int i = this.charBuffer.position(); i < this.charBuffer.limit() && j < n; ++i) {
            rval[j++] = this.charBuffer.get(i);
        }
        while (j < n) {
            rval[j++] = 63;
        }
        return rval;
    }

    private void readUntilBufferProvidesAtLeast(int needed) throws IOException {
        int remaining;
        while ((remaining = this.charBuffer.remaining()) < needed) {
            int n;
            logger.debug("Reading from input stream because at least {} chars are needed and only {} are available", (Object)needed, (Object)remaining);
            this.charBuffer.compact();
            while ((n = this.inputReader.read(this.charBuffer)) == 0) {
            }
            ((Buffer)this.charBuffer).flip();
            if (n < 0) {
                logger.debug("Hit end of file on the input stream");
                this.endOfFile = true;
                break;
            }
            logger.debug("Number of chars read from input stream: {}", (Object)n);
        }
    }
}

