/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.tokenizer;

import com.berryworks.edireader.EDISyntaxException;
import com.berryworks.edireader.tokenizer.Token;
import com.berryworks.edireader.tokenizer.Tokenizer;
import java.nio.Buffer;
import java.nio.CharBuffer;

public class TokenImpl
implements Token {
    private final Tokenizer tokenizer;
    private final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private CharBuffer valueBuffer = CharBuffer.wrap(new char[10]);
    private Token.TokenType type = Token.TokenType.UNKNOWN;
    private int index;
    private int subElementIndex;
    private boolean lastSubElement;
    private boolean containsNonSpace;
    private String segmentType = "";

    public TokenImpl(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    @Override
    public Token.TokenType getType() {
        return this.type;
    }

    @Override
    public boolean isFirst() {
        return this.subElementIndex == 0;
    }

    @Override
    public boolean isLast() {
        return this.lastSubElement;
    }

    @Override
    public void setLast(boolean value) {
        this.lastSubElement = value;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int getSubIndex() {
        return this.subElementIndex;
    }

    @Override
    public void setValue(char c) {
        this.resetValue();
        this.append(c);
    }

    @Override
    public char[] getValueChars() {
        return this.valueBuffer.array();
    }

    @Override
    public int getValueLength() {
        return this.valueBuffer.position();
    }

    @Override
    public String getValue() {
        ((Buffer)this.valueBuffer).flip();
        String s = this.valueBuffer.toString();
        this.valueBuffer.compact();
        return s;
    }

    @Override
    public boolean valueEquals(String v) {
        return this.getValue().equals(v);
    }

    @Override
    public String getSegmentType() {
        return this.segmentType;
    }

    @Override
    public void setSegmentType(String s) throws EDISyntaxException {
        this.segmentType = s;
        if ("".equals(this.segmentType)) {
            throw new EDISyntaxException("Invalid beginning of segment", this.tokenizer);
        }
    }

    @Override
    public boolean containsNonSpace() {
        return this.containsNonSpace;
    }

    public String toString() {
        return "Token type=" + (Object)((Object)this.getType()) + " value=" + this.getValue() + " index=" + this.getIndex() + " segment=" + this.getSegmentType();
    }

    @Override
    public String getElementId() {
        String result = this.getSegmentType();
        int n = this.getIndex();
        if (n < 10) {
            return result + '0' + this.digits[n];
        }
        return result + n;
    }

    @Override
    public void resetIndexes() {
        this.subElementIndex = 0;
        this.index = 0;
    }

    @Override
    public void resetSubElementIndex() {
        this.subElementIndex = 0;
    }

    @Override
    public void incrementIndex() {
        ++this.index;
    }

    @Override
    public void incrementSubElementIndex() {
        ++this.subElementIndex;
    }

    @Override
    public void setType(Token.TokenType tokenType) {
        this.type = tokenType;
    }

    @Override
    public void append(char c) {
        if (!this.valueBuffer.hasRemaining()) {
            this.enlarge();
        }
        this.valueBuffer.put(c);
        if (!this.containsNonSpace && c != ' ') {
            this.containsNonSpace = true;
        }
    }

    private void enlarge() {
        CharBuffer newBuffer = CharBuffer.wrap(new char[2 * this.valueBuffer.capacity()]);
        this.valueBuffer.compact();
        newBuffer.append(this.valueBuffer);
        this.valueBuffer = newBuffer;
    }

    @Override
    public void resetValue() {
        ((Buffer)this.valueBuffer).clear();
        this.containsNonSpace = false;
    }
}

