/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.util;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class BranchingWriter
extends FilterWriter {
    private boolean branchActive;
    private StringWriter branch;
    private StringWriter trunk;

    public BranchingWriter(Writer out) {
        super(out);
    }

    @Override
    public void write(int c) throws IOException {
        if (this.branchActive) {
            this.trunk.write(c);
            this.branch.write(c);
        } else {
            super.write(c);
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.branchActive) {
            this.trunk.write(cbuf, off, len);
            this.branch.write(cbuf, off, len);
        } else {
            super.write(cbuf, off, len);
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (this.branchActive) {
            this.trunk.write(str, off, len);
            this.branch.write(str, off, len);
        } else {
            super.write(str, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.branchActive) {
            this.trunk.flush();
            this.branch.flush();
        } else {
            super.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.branchActive) {
            this.out.write(this.trunk.toString());
            this.out.close();
        } else {
            super.close();
        }
    }

    public void writeTrunk(String s) {
        if (!this.branchActive) {
            this.branchActive = true;
            this.trunk = new StringWriter();
            this.branch = new StringWriter();
        }
        this.trunk.write(s);
    }

    public void writeBranch(String s) {
        if (!this.branchActive) {
            this.branchActive = true;
            this.trunk = new StringWriter();
            this.branch = new StringWriter();
        }
        this.branch.write(s);
    }

    public void closeUsingBranch() throws IOException {
        if (this.branchActive) {
            this.out.write(this.branch.toString());
            this.out.close();
        } else {
            super.close();
        }
    }
}

