/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.util;

import com.berryworks.edireader.util.base64.AbstractEncoder;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ContentHandlerBase64Encoder
extends AbstractEncoder {
    private ContentHandler contentHandler;
    private ByteBuffer base64Bytes;

    public void encode(char[] dataObject, ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
        CharBuffer charBuffer = CharBuffer.wrap(dataObject);
        ByteBuffer byteBuffer = ByteBuffer.allocate(100);
        this.base64Bytes = ByteBuffer.allocate(100);
        CharsetEncoder encoder = charset.newEncoder();
        while (true) {
            CoderResult coderResult;
            if ((coderResult = encoder.encode(charBuffer, byteBuffer, true)).isError()) {
                throw new RuntimeException("Unrecoverable failure in Base64 encoding");
            }
            ((Buffer)byteBuffer).flip();
            while (byteBuffer.hasRemaining()) {
                this.consume(byteBuffer.get());
            }
            if (coderResult.isUnderflow()) break;
            ((Buffer)byteBuffer).clear();
        }
        this.endOfData();
        this.feedContentHandler();
    }

    @Override
    protected void emit(byte b) {
        if (!this.base64Bytes.hasRemaining()) {
            this.feedContentHandler();
            ((Buffer)this.base64Bytes).clear();
        }
        this.base64Bytes.put(b);
    }

    private void feedContentHandler() {
        ((Buffer)this.base64Bytes).flip();
        CharBuffer charBuffer = charset.decode(this.base64Bytes);
        try {
            this.contentHandler.characters(charBuffer.array(), 0, charBuffer.length());
        }
        catch (SAXException e) {
            throw new RuntimeException("Unrecoverable failure in Base64 encoding");
        }
    }
}

