/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.util;

public class FileSequenceNameGenerator {
    protected final String filenamePattern;
    protected String filenameSuffix = "";
    protected String filenamePrefix = "";
    protected int sequenceNumberLength;
    private int count;

    public FileSequenceNameGenerator(String filenamePattern) {
        this.filenamePattern = filenamePattern;
        this.establishPattern();
    }

    private void establishPattern() {
        boolean haveSeen0 = false;
        for (int n = this.filenamePattern.length() - 1; n >= 0; --n) {
            char c = this.filenamePattern.charAt(n);
            if (c == '0') {
                haveSeen0 = true;
                ++this.sequenceNumberLength;
                continue;
            }
            if (haveSeen0) {
                this.filenamePrefix = this.filenamePattern.substring(0, n + 1);
                break;
            }
            this.filenameSuffix = c + this.filenameSuffix;
        }
        if (!haveSeen0) {
            throw new RuntimeException("Filename pattern must include a sequence one or more '0's.");
        }
    }

    public String generateName() {
        String sequenceDigits = "" + (100000 + ++this.count);
        sequenceDigits = sequenceDigits.substring(sequenceDigits.length() - this.sequenceNumberLength);
        return this.filenamePrefix + sequenceDigits + this.filenameSuffix;
    }

    public String getFilenamePattern() {
        return this.filenamePattern;
    }
}

