/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.util;

import java.util.List;

public abstract class FixedLength {
    private static final String DEFAULT_SPACES = "                                                  ";
    private static final String DEFAULT_ZEROES = "00000000000000000000000000000000000000000000000000";

    public static String valueOf(int value, int size) {
        if (size > 12) {
            throw new RuntimeException("FixedLength.valueOf support not available for sizes > 12 (" + size + " requested)");
        }
        long n = 1000000000000L + (long)value;
        String digits = String.valueOf(n);
        return digits.substring(digits.length() - size);
    }

    public static String valueOf(String value, int size) {
        if (value == null) {
            return FixedLength.spaces(size);
        }
        int n = value.length();
        if (n == size) {
            return value;
        }
        if (n > size) {
            return value.substring(0, size);
        }
        return value + FixedLength.spaces(size - n);
    }

    public static String leadingZeros(String value, int size) {
        if (value == null) {
            return FixedLength.zeroes(size);
        }
        int n = value.length();
        if (n == size) {
            return value;
        }
        if (n > size) {
            return value.substring(0, size);
        }
        return FixedLength.zeroes(size - n) + value;
    }

    public static String spaces(int n) {
        if (n > DEFAULT_SPACES.length()) {
            throw new RuntimeException("Unexpectedly large number of spaces to generate: " + n);
        }
        return DEFAULT_SPACES.substring(0, Math.max(n, 0));
    }

    public static String zeroes(int n) {
        if (n > DEFAULT_ZEROES.length()) {
            throw new RuntimeException("Unexpectedly large number of zeroes to generate: " + n);
        }
        return DEFAULT_ZEROES.substring(0, Math.max(n, 0));
    }

    public static boolean isPresent(String value) {
        return value != null && value.length() > 0;
    }

    public static boolean isPresent(List<?> list) {
        return list != null && list.size() > 0;
    }

    public static String emptyIfNull(String value) {
        return value == null ? "" : value;
    }
}

