/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.util;

import com.berryworks.edireader.EDIReader;
import com.berryworks.edireader.EDIReaderFactory;
import com.berryworks.edireader.demo.EDItoXML;
import com.berryworks.edireader.util.CommandLine;
import com.berryworks.edireader.util.FileSequenceNameGenerator;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Splitter {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getSimpleName());
    private static int count;
    private final InputSource inputSource;
    private EDIReader parser;
    private final FileSequenceNameGenerator handlerFactory;

    public Splitter(Reader inputReader, String outputFileNamePattern) {
        this.inputSource = new InputSource(inputReader);
        this.handlerFactory = new FileSequenceNameGenerator(outputFileNamePattern);
    }

    public void run() throws IOException, SAXException {
        this.split(this.inputSource);
    }

    public void split(InputSource inputSource) throws IOException, SAXException {
        char[] leftOver = null;
        while ((this.parser = EDIReaderFactory.createEDIReader(inputSource, leftOver)) != null) {
            String outputFilename = this.handlerFactory.generateName();
            logger.info("EDI interchange written to {}", (Object)outputFilename);
            this.parser.setContentHandler(new ScanningHandler());
            try (FileWriter writer = new FileWriter(outputFilename);){
                this.parser.setCopyWriter(writer);
                this.parser.parse(inputSource);
            }
            leftOver = this.parser.getTokenizer().getBuffered();
        }
    }

    public static void main(String[] args) {
        CommandLine commandLine = new CommandLine(args);
        String inputFileName = commandLine.getPosition(0);
        String outputFileNamePattern = commandLine.getOption("o");
        if (outputFileNamePattern == null) {
            Splitter.badArgs();
        }
        Reader inputReader = EDItoXML.establishInput(inputFileName);
        Splitter ediSplitter = new Splitter(inputReader, outputFileNamePattern);
        try {
            ediSplitter.run();
        }
        catch (IOException | SAXException e) {
            System.out.print(e);
            throw new RuntimeException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new RuntimeException(e.getMessage());
        }
    }

    private static void badArgs() {
        System.err.println("Usage: Splitter [inputFile] [-o outputFilenamePattern]");
        throw new RuntimeException("Missing or invalid command line arguments");
    }

    public static int getCount() {
        return count;
    }

    private class ScanningHandler
    extends DefaultHandler {
        private ScanningHandler() {
        }

        @Override
        public void startElement(String namespace, String localName, String qName, Attributes atts) throws SAXException {
            String indent;
            if (localName.startsWith(Splitter.this.parser.getXMLTags().getInterchangeTag())) {
                indent = "   ";
            } else if (localName.startsWith(Splitter.this.parser.getXMLTags().getSenderTag())) {
                logger.debug("  +Sender");
                indent = "     ";
            } else if (localName.startsWith(Splitter.this.parser.getXMLTags().getReceiverTag())) {
                logger.debug("  +Recipient");
                indent = "     ";
            } else if (localName.startsWith(Splitter.this.parser.getXMLTags().getAddressTag())) {
                logger.debug("    +Address");
                indent = "       ";
            } else if (localName.startsWith(Splitter.this.parser.getXMLTags().getGroupTag())) {
                logger.debug("  +Group");
                indent = "     ";
            } else if (localName.startsWith(Splitter.this.parser.getXMLTags().getDocumentTag())) {
                logger.debug("    +Document");
                indent = "       ";
            } else {
                return;
            }
            for (int i = 0; i < atts.getLength(); ++i) {
                logger.debug("{}{}={}", new Object[]{indent, atts.getLocalName(i), atts.getValue(i)});
            }
        }
    }
}

