/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.util;

import com.berryworks.edireader.EDIReader;
import com.berryworks.edireader.EDISyntaxException;
import java.io.File;
import java.io.FileReader;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StandardRecognizer
implements Runnable {
    private final File ediFile;
    private String standard;

    public static void main(String[] args) {
        if (args.length < 1) {
            throw new RuntimeException("A filename argument is required");
        }
        File file = new File(args[0]);
        if (!file.exists() || file.isDirectory() || !file.canRead()) {
            throw new RuntimeException("Unable to read EDI data from " + file.getAbsolutePath());
        }
        StandardRecognizer standardRecognizer = new StandardRecognizer(file);
        standardRecognizer.run();
        System.out.println("Standard: " + standardRecognizer.getStandard());
    }

    public StandardRecognizer(File ediFIle) {
        this.ediFile = ediFIle;
    }

    @Override
    public void run() {
        try (FileReader fileReader = new FileReader(this.ediFile);){
            EDIReader ediReader = new EDIReader();
            MyContentHandler handler = new MyContentHandler();
            ediReader.setContentHandler(handler);
            ediReader.parse(new InputSource(fileReader));
        }
        catch (EDISyntaxException e) {
            this.standard = "Binary";
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parse EDI input", e);
        }
    }

    public String getStandard() {
        return this.standard;
    }

    private class MyContentHandler
    extends DefaultHandler {
        private MyContentHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("interchange".equals(localName)) {
                StandardRecognizer.this.standard = attributes.getValue("Standard");
            }
        }
    }
}

