/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.util;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class XmlFormatter
extends FilterWriter {
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static final String INDENT = "    ";
    private char mostRecentCharOfInterest;
    private String currentIndent = "";
    private State state = State.NORMAL_TEXT;

    public XmlFormatter(Writer writer) {
        super(writer);
    }

    @Override
    public void write(int i) throws IOException {
        if (i <= 0) {
            super.write(i);
        } else {
            this.process((char)i);
        }
    }

    protected void process(char c) throws IOException {
        switch (this.state) {
            case NORMAL_TEXT: {
                if (c == '>') {
                    this.state = State.HOLDING_A_CLOSE;
                    break;
                }
                if (this.isCharacterOfInterest(c)) {
                    this.mostRecentCharOfInterest = c;
                }
                this.out.write(c);
                break;
            }
            case HOLDING_A_CLOSE: {
                if (c == '<') {
                    this.state = State.HOLDING_A_CLOSE_FOLLOWED_BY_OPEN;
                    break;
                }
                this.out.write(62);
                this.out.write(c);
                this.state = State.NORMAL_TEXT;
                break;
            }
            case HOLDING_A_CLOSE_FOLLOWED_BY_OPEN: {
                this.out.write(62);
                this.out.write(this.indentionAsNeeded(c));
                this.out.write(60);
                this.out.write(c);
                this.state = State.NORMAL_TEXT;
            }
        }
    }

    private String indentionAsNeeded(char currentChar) {
        if (currentChar == '/') {
            this.currentIndent = XmlFormatter.shrink(this.currentIndent);
        } else if (this.mostRecentCharOfInterest == '?') {
            this.mostRecentCharOfInterest = (char)60;
        } else if (this.mostRecentCharOfInterest == '/') {
            this.mostRecentCharOfInterest = (char)60;
        } else {
            this.currentIndent = this.currentIndent + INDENT;
        }
        return SEPARATOR + this.currentIndent;
    }

    private boolean isCharacterOfInterest(char c) {
        return c == '<' || c == '?' || c == '/';
    }

    @Override
    public void write(char[] chars, int startIndex, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            this.process(chars[startIndex + i]);
        }
    }

    @Override
    public void write(String text, int startIndex, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            this.process(text.charAt(startIndex + i));
        }
    }

    @Override
    public void close() throws IOException {
        switch (this.state) {
            case NORMAL_TEXT: {
                break;
            }
            case HOLDING_A_CLOSE: {
                this.out.write(62);
                break;
            }
            case HOLDING_A_CLOSE_FOLLOWED_BY_OPEN: {
                this.out.write(62);
                this.out.write(60);
            }
        }
        super.close();
    }

    public static String format(String xmlText) {
        int i;
        String indent = "";
        int startLookingAtIndex = 0;
        while ((i = xmlText.indexOf("><", startLookingAtIndex)) >= 0) {
            char peekAhead = xmlText.charAt(i + 2);
            int delta = XmlFormatter.changeIndent(xmlText, i, peekAhead);
            if (delta < 0) {
                indent = XmlFormatter.shrink(indent);
            } else if (delta > 0) {
                indent = indent + INDENT;
            }
            String insertedWhitespace = SEPARATOR + indent;
            xmlText = xmlText.substring(0, i + 1) + insertedWhitespace + xmlText.substring(i + 1);
            startLookingAtIndex = i + insertedWhitespace.length() + 1;
        }
        return xmlText;
    }

    private static String shrink(String indent) {
        if (indent == null || indent.length() <= INDENT.length()) {
            return "";
        }
        return indent.substring(INDENT.length());
    }

    private static int changeIndent(String xmlText, int startingIndex, char peekAhead) {
        int index = startingIndex;
        while (--index > 0) {
            char c = xmlText.charAt(index);
            switch (c) {
                case '<': {
                    return 1;
                }
                case '?': {
                    return 0;
                }
                case '/': {
                    if (index + 1 == startingIndex) {
                        return -1;
                    }
                    return peekAhead == '/' ? -1 : 0;
                }
            }
        }
        return 0;
    }

    private char priorNonWhitespace(String xmlText, int index) {
        char c;
        do {
            if (--index > 0) continue;
            return xmlText.charAt(0);
        } while (Character.isWhitespace(c = xmlText.charAt(index)));
        return c;
    }

    private boolean isClosing(String xmlText, int index) {
        while (--index > 0) {
            char c = xmlText.charAt(index);
            switch (c) {
                case '<': {
                    return false;
                }
                case '/': 
                case '?': {
                    return true;
                }
            }
        }
        return false;
    }

    private static enum State {
        NORMAL_TEXT,
        HOLDING_A_CLOSE,
        HOLDING_A_CLOSE_FOLLOWED_BY_OPEN;

    }
}

