/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.util.base64;

import com.berryworks.edireader.util.base64.AbstractEncoderDecoder;
import java.nio.CharBuffer;

public abstract class EncoderBackEnd
extends AbstractEncoderDecoder {
    private static final String ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
    private static final byte[] base64Alphabet = charset.encode(CharBuffer.wrap("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=")).array();
    private static final byte pad = base64Alphabet[64];
    private byte previous;

    @Override
    public void consume(byte b) {
        switch (this.state) {
            case 0: {
                this.emit(base64Alphabet[b]);
                this.state = 3;
                break;
            }
            case 3: {
                this.previous = b;
                this.state = 1;
                break;
            }
            case 1: {
                this.emit(base64Alphabet[this.previous << 4 | b]);
                this.state = 4;
                break;
            }
            case 4: {
                this.previous = b;
                this.state = 2;
                break;
            }
            case 2: {
                this.emit(base64Alphabet[this.previous << 2 | b]);
                this.state = 5;
                break;
            }
            case 5: {
                this.emit(base64Alphabet[b]);
                this.state = 0;
            }
        }
    }

    @Override
    public void endOfData() {
        switch (this.state) {
            case 0: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 1: {
                this.emit(base64Alphabet[this.previous << 4]);
                this.emit(pad);
                this.emit(pad);
                break;
            }
            case 2: {
                this.emit(base64Alphabet[this.previous << 2]);
                this.emit(pad);
            }
        }
    }
}

