/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.util.dom;

import com.berryworks.edireader.util.dom.AbstractElementList;
import java.util.ListIterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ChildElements
extends AbstractElementList {
    private final Node parentNode;
    private final String tag;

    public ChildElements(Node node) {
        this(node, null);
    }

    public ChildElements(Node node, String tag) {
        this.parentNode = node;
        this.tag = tag;
    }

    @Override
    public ListIterator<Element> listIterator(int index) {
        if (index != 0) {
            throw new RuntimeException("index was " + index + " instead of 0 as expected");
        }
        return new ElementListIterator(this.parentNode);
    }

    private class ElementListIterator
    extends AbstractElementList.AbstractElementListIterator {
        private Element next;

        public ElementListIterator(Node parentNode) {
            Node nextNode;
            for (nextNode = parentNode.getFirstChild(); nextNode != null && (!(nextNode instanceof Element) || ChildElements.this.tag != null && !ChildElements.this.tag.equals(nextNode.getNodeName())); nextNode = nextNode.getNextSibling()) {
            }
            this.next = (Element)nextNode;
        }

        @Override
        public Element next() {
            Node nextNode;
            Element result = this.next;
            for (nextNode = this.next.getNextSibling(); nextNode != null && (!(nextNode instanceof Element) || ChildElements.this.tag != null && !ChildElements.this.tag.equals(nextNode.getNodeName())); nextNode = nextNode.getNextSibling()) {
            }
            this.next = (Element)nextNode;
            return result;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }
    }
}

