/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.util.sax;

import com.berryworks.edireader.EDIAttributes;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class ContextAwareSaxAdapter
extends DefaultHandler {
    private boolean pending = false;
    private String pendingUri;
    private String pendingName;
    private EDIAttributes pendingAttributes;
    private String pendingData;
    private final List<String> context = new ArrayList<String>();
    private final boolean isTrimmingEnabled;

    public ContextAwareSaxAdapter() {
        this(true);
    }

    public ContextAwareSaxAdapter(boolean isTrimmingEnabled) {
        this.isTrimmingEnabled = isTrimmingEnabled;
    }

    @Override
    public final void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.applyPending();
        this.pendingUri = uri;
        this.pendingName = localName;
        this.pendingAttributes = new EDIAttributes(attributes);
        this.pending = true;
        this.context.add(this.representationOf(localName, attributes));
    }

    protected String representationOf(String localName, Attributes attributes) {
        return localName;
    }

    @Override
    public final void endElement(String uri, String localName, String qName) throws SAXException {
        int indexOfLast;
        String lastOne;
        this.applyPending();
        this.end(uri, localName);
        if (this.context.size() > 0 && localName.equals(lastOne = this.context.get(indexOfLast = this.context.size() - 1))) {
            this.context.remove(indexOfLast);
        }
    }

    private void applyPending() throws SAXException {
        if (this.pending) {
            if (this.pendingData != null && this.isTrimmingEnabled) {
                this.pendingData = this.pendingData.trim();
            }
            this.start(this.pendingUri, this.pendingName, this.pendingData, this.pendingAttributes);
        }
        this.pending = false;
        this.pendingData = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String fragment = new String(ch, start, length);
        this.pendingData = this.pendingData == null ? fragment : this.pendingData + fragment;
    }

    public abstract void start(String var1, String var2, String var3, EDIAttributes var4) throws SAXException;

    public abstract void end(String var1, String var2) throws SAXException;

    public List<String> getContext() {
        return this.context;
    }
}

