/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.util.sax;

import com.berryworks.edireader.XMLTags;
import com.berryworks.edireader.tokenizer.SourcePosition;
import java.io.PrintStream;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EDIReaderSAXAdapter
extends DefaultHandler
implements SourcePosition {
    protected final XMLTags xmlTags;
    protected boolean anotherSEG;
    protected boolean implicitGroup;
    protected boolean implicitDocument;
    private int charCount = -1;
    private int segmentCharCount = -1;
    private boolean implicitInterchangeTermination;
    private boolean senderAddress;
    protected String elementString;

    public EDIReaderSAXAdapter(XMLTags xmlTags) {
        this.xmlTags = xmlTags;
    }

    @Override
    public void startElement(String namespace, String localName, String qName, Attributes atts) throws SAXException {
        int charCount = this.getCharCount();
        int segmentCharCount = this.getSegmentCharCount();
        if (localName.startsWith(this.xmlTags.getInterchangeTag())) {
            this.anotherSEG = false;
            this.beginInterchange(charCount, segmentCharCount, atts);
        } else if (localName.startsWith(this.xmlTags.getSenderTag())) {
            this.senderAddress = true;
        } else if (localName.startsWith(this.xmlTags.getReceiverTag())) {
            this.senderAddress = false;
        } else if (localName.startsWith(this.xmlTags.getAddressTag())) {
            String qualifier = atts.getValue(this.xmlTags.getQualifierAttribute());
            String address = atts.getValue(this.xmlTags.getIdAttribute());
            String extra = atts.getValue(this.xmlTags.getAddressExtraAttribute());
            if (this.senderAddress) {
                this.senderAddress(qualifier, address, extra);
            } else {
                this.receiverAddress(qualifier, address, extra);
            }
        } else if (localName.startsWith(this.xmlTags.getGroupTag())) {
            this.anotherSEG = false;
            if (atts.getLength() == 0) {
                this.implicitGroup = true;
                this.beginImplicitGroup();
            } else {
                this.beginExplicitGroup(charCount, segmentCharCount, atts);
            }
        } else if (localName.startsWith(this.xmlTags.getDocumentTag())) {
            this.anotherSEG = false;
            if (atts.getLength() == 0) {
                this.implicitDocument = true;
                this.beginImplicitDocument();
            } else {
                this.beginDocument(charCount, segmentCharCount, atts);
            }
        } else if (localName.startsWith(this.xmlTags.getSegTag())) {
            if (this.anotherSEG) {
                this.beginAnotherSegment(atts);
            } else {
                this.beginFirstSegment(atts);
                this.anotherSEG = true;
            }
        } else if (localName.startsWith(this.xmlTags.getLoopTag())) {
            this.anotherSEG = true;
            String loopName = "";
            if (atts.getLength() > 0) {
                loopName = atts.getValue(0);
            }
            this.beginSegmentGroup(loopName, atts);
        } else if (localName.startsWith(this.xmlTags.getPackageTag())) {
            this.beginBinaryPackage(atts);
        } else if (localName.startsWith(this.xmlTags.getElementTag())) {
            this.elementString = "";
            this.beginSegmentElement(atts);
        } else if (localName.startsWith(this.xmlTags.getSubElementTag())) {
            this.elementString = "";
            this.beginSegmentSubElement(atts);
        }
    }

    @Override
    public void setCharCounts(int charCount, int segmentCharCount) {
        this.charCount = charCount;
        this.segmentCharCount = segmentCharCount;
    }

    @Override
    public int getCharCount() {
        return this.charCount;
    }

    @Override
    public int getSegmentCharCount() {
        return this.segmentCharCount;
    }

    @Override
    public void endElement(String namespace, String localName, String qName) throws SAXException {
        int charCount = this.getCharCount();
        int segmentCharCount = this.getSegmentCharCount();
        if (localName.startsWith(this.xmlTags.getInterchangeTag())) {
            this.anotherSEG = false;
            this.endInterchange(charCount, segmentCharCount);
            this.implicitInterchangeTermination = false;
        } else if (localName.startsWith(this.xmlTags.getGroupTag())) {
            this.anotherSEG = false;
            if (this.implicitGroup) {
                this.endImplicitGroup();
            } else {
                this.endExplicitGroup(charCount, segmentCharCount);
            }
        } else if (localName.startsWith(this.xmlTags.getDocumentTag())) {
            this.anotherSEG = false;
            if (!this.implicitDocument) {
                this.endDocument(charCount, segmentCharCount);
            }
        } else if (localName.startsWith(this.xmlTags.getSegTag())) {
            this.endSegment(charCount, segmentCharCount);
        } else if (localName.startsWith(this.xmlTags.getPackageTag())) {
            this.endBinaryPackage(charCount, segmentCharCount);
        } else if (localName.startsWith(this.xmlTags.getElementTag())) {
            this.endSegmentElement(this.elementString);
            this.elementString = null;
        } else if (localName.startsWith(this.xmlTags.getSubElementTag())) {
            this.endSegmentSubElement(this.elementString);
            this.elementString = null;
        } else if (localName.startsWith(this.xmlTags.getLoopTag())) {
            this.endSegmentGroup();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String s = new String(ch, start, length);
        if (this.elementString != null) {
            this.elementString = this.elementString + s;
        }
    }

    public boolean isImplicitInterchangeTermination() {
        return this.implicitInterchangeTermination;
    }

    public void preface() {
    }

    public void addendum() {
    }

    protected void beginInterchange(int charCount, int segmentCharCount, Attributes attributes) {
    }

    protected void senderAddress(String qualifier, String address, String extra) {
    }

    protected void receiverAddress(String qualifier, String address, String extra) {
    }

    protected void endInterchange(int charCount, int segmentCharCount) {
    }

    protected void beginExplicitGroup(int charCount, int segmentCharCount, Attributes attributes) {
    }

    protected void endExplicitGroup(int charCount, int segmentCharCount) {
    }

    protected void beginImplicitGroup() {
    }

    protected void endImplicitGroup() {
    }

    protected void beginSegmentGroup(String loopName, Attributes atts) {
    }

    protected void beginFirstSegment(Attributes atts) {
        this.beginAnotherSegment(atts);
    }

    protected void beginAnotherSegment(Attributes atts) {
    }

    protected void beginBinaryPackage(Attributes atts) {
    }

    protected void beginDocument(int charCount, int segmentCharCount, Attributes attributes) {
    }

    protected void endDocument(int charCount, int segmentCharCount) {
    }

    protected void beginImplicitDocument() {
    }

    protected void endSegment(int charCount, int segmentCharCount) {
    }

    protected void endBinaryPackage(int charCount, int segmentCharCount) {
    }

    protected void endSegmentGroup() {
    }

    protected void beginSegmentElement(Attributes atts) {
    }

    protected void endSegmentElement(String elementString) {
    }

    protected void beginSegmentSubElement(Attributes atts) {
    }

    protected void endSegmentSubElement(String subElementString) {
    }

    protected void recover(Exception e) {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if ("interchangeTermination".equals(target) && "implicit".equals(data)) {
            this.implicitInterchangeTermination = true;
        }
    }

    protected void printAttributes(Attributes atts, PrintStream out) {
        for (int i = 0; i < atts.getLength(); ++i) {
            out.println("attribute " + i + ": " + atts.getLocalName(i) + "=" + atts.getValue(i));
        }
    }
}

