/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.util.sax;

import com.berryworks.edireader.EDIAttributes;
import com.berryworks.edireader.tokenizer.SourcePosition;
import com.berryworks.edireader.util.FixedLength;
import com.berryworks.edireader.util.sax.QueuedEndItem;
import com.berryworks.edireader.util.sax.QueuedItem;
import com.berryworks.edireader.util.sax.QueuedStartItem;
import java.util.LinkedList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class QueuedContentHandler
extends DefaultHandler {
    private final ContentHandler wrappedHandler;
    private final LinkedList<QueuedItem> queue = new LinkedList();
    private final int queueSizeLimit;
    private final SourcePosition sourcePosition;

    public QueuedContentHandler(ContentHandler handler, int queueSizeLimit, SourcePosition sourcePosition) {
        this.wrappedHandler = handler;
        this.queueSizeLimit = queueSizeLimit;
        this.sourcePosition = sourcePosition;
    }

    @Override
    public void startDocument() throws SAXException {
        this.wrappedHandler.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.drainQueue();
        this.wrappedHandler.endDocument();
    }

    public void drainQueue() throws SAXException {
        while (this.queue.size() > 0) {
            this.queue.removeFirst().process(this.wrappedHandler);
        }
        if (this.wrappedHandler instanceof SourcePosition) {
            ((SourcePosition)((Object)this.wrappedHandler)).setCharCounts(-1, -1);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.limitSize();
        int charCount = this.sourcePosition == null ? 0 : this.sourcePosition.getCharCount();
        int segmentCharCount = this.sourcePosition == null ? 0 : this.sourcePosition.getSegmentCharCount();
        this.queue.add(new QueuedStartItem(uri, localName, qName, attributes, charCount, segmentCharCount));
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.limitSize();
        int charCount = this.sourcePosition == null ? 0 : this.sourcePosition.getCharCount();
        int segmentCharCount = this.sourcePosition == null ? 0 : this.sourcePosition.getSegmentCharCount();
        this.queue.add(new QueuedEndItem(uri, localName, qName, charCount, segmentCharCount));
    }

    private void limitSize() throws SAXException {
        while (this.queue.size() >= this.queueSizeLimit) {
            QueuedItem queuedItem = this.queue.removeFirst();
            queuedItem.process(this.wrappedHandler);
        }
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        this.characters(new String(chars, start, length));
    }

    public void characters(String data) {
        this.queue.getLast().addData(data);
    }

    public String getAttribute(String tag, String attributeName) {
        for (int i = this.queue.size() - 1; i >= 0; --i) {
            QueuedItem queuedItem = this.queue.get(i);
            if (!tag.equals(queuedItem.getLocalName())) continue;
            EDIAttributes attributes = queuedItem.getAttributes();
            return attributes.getValue(attributeName);
        }
        return null;
    }

    public void putAttribute(String tag, String attributeName, String data) {
        if (!FixedLength.isPresent(data)) {
            return;
        }
        for (int i = this.queue.size() - 1; i >= 0; --i) {
            QueuedItem queuedItem = this.queue.get(i);
            if (!tag.equals(queuedItem.getLocalName())) continue;
            EDIAttributes attributes = queuedItem.getAttributes();
            int index = attributes.getIndex(attributeName);
            if (index >= 0) {
                attributes.removeAttribute(index);
            }
            attributes.addCDATA(attributeName, data);
            return;
        }
        throw new RuntimeException("Could not find queued element " + tag + " for putAttribute()");
    }

    EDIAttributes getFirstAttributes() {
        if (this.queue.size() == 0) {
            return null;
        }
        return this.queue.getFirst().getAttributes();
    }

    public ContentHandler getWrappedContentHandler() {
        return this.wrappedHandler;
    }
}

