/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.util.sax;

import com.berryworks.edireader.EDIAttributes;
import com.berryworks.edireader.tokenizer.SourcePosition;
import com.berryworks.edireader.util.sax.QueuedItem;
import com.berryworks.edireader.util.sax.StartWithDataContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class QueuedStartItem
extends QueuedItem {
    private final EDIAttributes attributes;
    private String data;

    public QueuedStartItem(String uri, String localName, String qName, Attributes attributes, int charCount, int segmentCharCount) {
        super(uri, localName, qName, charCount, segmentCharCount);
        this.attributes = new EDIAttributes(attributes);
    }

    @Override
    public EDIAttributes getAttributes() {
        return this.attributes;
    }

    public String getData() {
        return this.data;
    }

    @Override
    public void addData(String data) {
        this.data = this.data == null ? data : this.data + data;
    }

    @Override
    public void process(ContentHandler handler) throws SAXException {
        EDIAttributes attributes1 = this.getAttributes();
        if (attributes1 == null) {
            throw new RuntimeException("null attributes");
        }
        String name = this.getLocalName();
        if (name == null) {
            throw new RuntimeException("null name");
        }
        String qname = this.getQName();
        if (qname == null) {
            throw new RuntimeException("null qname");
        }
        String uri = this.getUri();
        if (uri == null) {
            throw new RuntimeException("null uri");
        }
        if (handler instanceof SourcePosition) {
            ((SourcePosition)((Object)handler)).setCharCounts(this.getCharCount(), this.getSegmentCharCount());
        }
        if (handler instanceof StartWithDataContentHandler) {
            StartWithDataContentHandler startWithDataContentHandler = (StartWithDataContentHandler)handler;
            startWithDataContentHandler.startElement(uri, name, qname, attributes1, this.getData());
        } else {
            handler.startElement(uri, name, qname, attributes1);
            if (this.getData() != null) {
                char[] ca = this.getData().toCharArray();
                handler.characters(ca, 0, ca.length);
            }
        }
    }
}

