/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.util.sax;

import com.berryworks.edireader.EDIAttributes;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StackedContentHandler
extends DefaultHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getSimpleName());
    private final ContentHandler wrappedHandler;
    private final List<StackedItem> stack = new ArrayList<StackedItem>();

    public StackedContentHandler(ContentHandler handler) {
        this.wrappedHandler = handler;
    }

    @Override
    public void startDocument() throws SAXException {
        this.wrappedHandler.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.wrappedHandler.endDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.stack.add(new StackedItem(uri, localName, qName, attributes));
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        for (StackedItem stackedItem : this.stack) {
            if (stackedItem.isStarted()) continue;
            stackedItem.start(this.wrappedHandler);
        }
        this.pop().end(this.wrappedHandler);
    }

    private StackedItem pop() {
        int n = this.stack.size();
        if (n == 0) {
            throw new RuntimeException("attempt to pop an empty stack");
        }
        return this.stack.remove(n - 1);
    }

    private void displayStack(String msg) {
        logger.info("{}, stack size {}", (Object)msg, (Object)this.stack.size());
        for (StackedItem stackedItem : this.stack) {
            logger.info("...{}", (Object)stackedItem.getLocalName());
        }
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        this.characters(new String(chars, start, length));
    }

    public void characters(String data) {
        this.stack.get(this.stack.size() - 1).addData(data);
    }

    public void addAttribute(String tag, String attributeName, String data) {
        for (StackedItem stackedItem : this.stack) {
            if (!tag.equals(stackedItem.getLocalName())) continue;
            EDIAttributes attributes = stackedItem.getAttributes();
            attributes.addCDATA(attributeName, data);
            logger.trace("Added {}={} to {}", new Object[]{attributeName, data, tag});
            return;
        }
        throw new RuntimeException("Could not find stacked element " + tag + " for putAttribute()");
    }

    static class StackedItem {
        private final String uri;
        private final String localName;
        private final String qName;
        private final EDIAttributes attributes;
        private String data;
        private boolean started;

        StackedItem(String uri, String localName, String qName, Attributes attributes) {
            this.uri = uri;
            this.localName = localName;
            this.qName = qName;
            this.attributes = new EDIAttributes(attributes);
        }

        public String getUri() {
            return this.uri;
        }

        public String getLocalName() {
            return this.localName;
        }

        public String getQName() {
            return this.qName;
        }

        public EDIAttributes getAttributes() {
            return this.attributes;
        }

        public String getData() {
            return this.data;
        }

        public boolean isStarted() {
            return this.started;
        }

        public void addData(String data) {
            this.data = this.data == null ? data : this.data + data;
        }

        public void start(ContentHandler handler) throws SAXException {
            handler.startElement(this.uri, this.localName, this.qName, this.attributes);
            if (this.data != null) {
                handler.characters(this.data.toCharArray(), 0, this.data.length());
            }
            this.started = true;
        }

        public void end(ContentHandler handler) throws SAXException {
            handler.endElement(this.uri, this.localName, this.qName);
        }
    }
}

